//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
// <p>
// http://www.apache.org/licenses/LICENSE-2.0
// <p>
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v4.23.4
// source: FlightSql.proto

package flight

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Options for CommandGetSqlInfo.
type SqlInfo int32

const (
	// Retrieves a UTF-8 string with the name of the Flight SQL Server.
	SqlInfo_FLIGHT_SQL_SERVER_NAME SqlInfo = 0
	// Retrieves a UTF-8 string with the native version of the Flight SQL Server.
	SqlInfo_FLIGHT_SQL_SERVER_VERSION SqlInfo = 1
	// Retrieves a UTF-8 string with the Arrow format version of the Flight SQL Server.
	SqlInfo_FLIGHT_SQL_SERVER_ARROW_VERSION SqlInfo = 2
	//
	// Retrieves a boolean value indicating whether the Flight SQL Server is read only.
	//
	// Returns:
	// - false: if read-write
	// - true: if read only
	SqlInfo_FLIGHT_SQL_SERVER_READ_ONLY SqlInfo = 3
	//
	// Retrieves a boolean value indicating whether the Flight SQL Server supports executing
	// SQL queries.
	//
	// Note that the absence of this info (as opposed to a false value) does not necessarily
	// mean that SQL is not supported, as this property was not originally defined.
	SqlInfo_FLIGHT_SQL_SERVER_SQL SqlInfo = 4
	//
	// Retrieves a boolean value indicating whether the Flight SQL Server supports executing
	// Substrait plans.
	SqlInfo_FLIGHT_SQL_SERVER_SUBSTRAIT SqlInfo = 5
	//
	// Retrieves a string value indicating the minimum supported Substrait version, or null
	// if Substrait is not supported.
	SqlInfo_FLIGHT_SQL_SERVER_SUBSTRAIT_MIN_VERSION SqlInfo = 6
	//
	// Retrieves a string value indicating the maximum supported Substrait version, or null
	// if Substrait is not supported.
	SqlInfo_FLIGHT_SQL_SERVER_SUBSTRAIT_MAX_VERSION SqlInfo = 7
	//
	// Retrieves an int32 indicating whether the Flight SQL Server supports the
	// BeginTransaction/EndTransaction/BeginSavepoint/EndSavepoint actions.
	//
	// Even if this is not supported, the database may still support explicit "BEGIN
	// TRANSACTION"/"COMMIT" SQL statements (see SQL_TRANSACTIONS_SUPPORTED); this property
	// is only about whether the server implements the Flight SQL API endpoints.
	//
	// The possible values are listed in `SqlSupportedTransaction`.
	SqlInfo_FLIGHT_SQL_SERVER_TRANSACTION SqlInfo = 8
	//
	// Retrieves a boolean value indicating whether the Flight SQL Server supports explicit
	// query cancellation (the CancelQuery action).
	SqlInfo_FLIGHT_SQL_SERVER_CANCEL SqlInfo = 9
	//
	// Retrieves an int32 indicating the timeout (in milliseconds) for prepared statement handles.
	//
	// If 0, there is no timeout.  Servers should reset the timeout when the handle is used in a command.
	SqlInfo_FLIGHT_SQL_SERVER_STATEMENT_TIMEOUT SqlInfo = 100
	//
	// Retrieves an int32 indicating the timeout (in milliseconds) for transactions, since transactions are not tied to a connection.
	//
	// If 0, there is no timeout.  Servers should reset the timeout when the handle is used in a command.
	SqlInfo_FLIGHT_SQL_SERVER_TRANSACTION_TIMEOUT SqlInfo = 101
	//
	// Retrieves a boolean value indicating whether the Flight SQL Server supports CREATE and DROP of catalogs.
	//
	// Returns:
	// - false: if it doesn't support CREATE and DROP of catalogs.
	// - true: if it supports CREATE and DROP of catalogs.
	SqlInfo_SQL_DDL_CATALOG SqlInfo = 500
	//
	// Retrieves a boolean value indicating whether the Flight SQL Server supports CREATE and DROP of schemas.
	//
	// Returns:
	// - false: if it doesn't support CREATE and DROP of schemas.
	// - true: if it supports CREATE and DROP of schemas.
	SqlInfo_SQL_DDL_SCHEMA SqlInfo = 501
	//
	// Indicates whether the Flight SQL Server supports CREATE and DROP of tables.
	//
	// Returns:
	// - false: if it doesn't support CREATE and DROP of tables.
	// - true: if it supports CREATE and DROP of tables.
	SqlInfo_SQL_DDL_TABLE SqlInfo = 502
	//
	// Retrieves a int32 ordinal representing the case sensitivity of catalog, table, schema and table names.
	//
	// The possible values are listed in `arrow.flight.protocol.sql.SqlSupportedCaseSensitivity`.
	SqlInfo_SQL_IDENTIFIER_CASE SqlInfo = 503
	// Retrieves a UTF-8 string with the supported character(s) used to surround a delimited identifier.
	SqlInfo_SQL_IDENTIFIER_QUOTE_CHAR SqlInfo = 504
	//
	// Retrieves a int32 describing the case sensitivity of quoted identifiers.
	//
	// The possible values are listed in `arrow.flight.protocol.sql.SqlSupportedCaseSensitivity`.
	SqlInfo_SQL_QUOTED_IDENTIFIER_CASE SqlInfo = 505
	//
	// Retrieves a boolean value indicating whether all tables are selectable.
	//
	// Returns:
	// - false: if not all tables are selectable or if none are;
	// - true: if all tables are selectable.
	SqlInfo_SQL_ALL_TABLES_ARE_SELECTABLE SqlInfo = 506
	//
	// Retrieves the null ordering.
	//
	// Returns a int32 ordinal for the null ordering being used, as described in
	// `arrow.flight.protocol.sql.SqlNullOrdering`.
	SqlInfo_SQL_NULL_ORDERING SqlInfo = 507
	// Retrieves a UTF-8 string list with values of the supported keywords.
	SqlInfo_SQL_KEYWORDS SqlInfo = 508
	// Retrieves a UTF-8 string list with values of the supported numeric functions.
	SqlInfo_SQL_NUMERIC_FUNCTIONS SqlInfo = 509
	// Retrieves a UTF-8 string list with values of the supported string functions.
	SqlInfo_SQL_STRING_FUNCTIONS SqlInfo = 510
	// Retrieves a UTF-8 string list with values of the supported system functions.
	SqlInfo_SQL_SYSTEM_FUNCTIONS SqlInfo = 511
	// Retrieves a UTF-8 string list with values of the supported datetime functions.
	SqlInfo_SQL_DATETIME_FUNCTIONS SqlInfo = 512
	//
	// Retrieves the UTF-8 string that can be used to escape wildcard characters.
	// This is the string that can be used to escape '_' or '%' in the catalog search parameters that are a pattern
	// (and therefore use one of the wildcard characters).
	// The '_' character represents any single character; the '%' character represents any sequence of zero or more
	// characters.
	SqlInfo_SQL_SEARCH_STRING_ESCAPE SqlInfo = 513
	//
	// Retrieves a UTF-8 string with all the "extra" characters that can be used in unquoted identifier names
	// (those beyond a-z, A-Z, 0-9 and _).
	SqlInfo_SQL_EXTRA_NAME_CHARACTERS SqlInfo = 514
	//
	// Retrieves a boolean value indicating whether column aliasing is supported.
	// If so, the SQL AS clause can be used to provide names for computed columns or to provide alias names for columns
	// as required.
	//
	// Returns:
	// - false: if column aliasing is unsupported;
	// - true: if column aliasing is supported.
	SqlInfo_SQL_SUPPORTS_COLUMN_ALIASING SqlInfo = 515
	//
	// Retrieves a boolean value indicating whether concatenations between null and non-null values being
	// null are supported.
	//
	// - Returns:
	// - false: if concatenations between null and non-null values being null are unsupported;
	// - true: if concatenations between null and non-null values being null are supported.
	SqlInfo_SQL_NULL_PLUS_NULL_IS_NULL SqlInfo = 516
	//
	// Retrieves a map where the key is the type to convert from and the value is a list with the types to convert to,
	// indicating the supported conversions. Each key and each item on the list value is a value to a predefined type on
	// SqlSupportsConvert enum.
	// The returned map will be:  map<int32, list<int32>>
	SqlInfo_SQL_SUPPORTS_CONVERT SqlInfo = 517
	//
	// Retrieves a boolean value indicating whether, when table correlation names are supported,
	// they are restricted to being different from the names of the tables.
	//
	// Returns:
	// - false: if table correlation names are unsupported;
	// - true: if table correlation names are supported.
	SqlInfo_SQL_SUPPORTS_TABLE_CORRELATION_NAMES SqlInfo = 518
	//
	// Retrieves a boolean value indicating whether, when table correlation names are supported,
	// they are restricted to being different from the names of the tables.
	//
	// Returns:
	// - false: if different table correlation names are unsupported;
	// - true: if different table correlation names are supported
	SqlInfo_SQL_SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES SqlInfo = 519
	//
	// Retrieves a boolean value indicating whether expressions in ORDER BY lists are supported.
	//
	// Returns:
	// - false: if expressions in ORDER BY are unsupported;
	// - true: if expressions in ORDER BY are supported;
	SqlInfo_SQL_SUPPORTS_EXPRESSIONS_IN_ORDER_BY SqlInfo = 520
	//
	// Retrieves a boolean value indicating whether using a column that is not in the SELECT statement in a GROUP BY
	// clause is supported.
	//
	// Returns:
	// - false: if using a column that is not in the SELECT statement in a GROUP BY clause is unsupported;
	// - true: if using a column that is not in the SELECT statement in a GROUP BY clause is supported.
	SqlInfo_SQL_SUPPORTS_ORDER_BY_UNRELATED SqlInfo = 521
	//
	// Retrieves the supported GROUP BY commands;
	//
	// Returns an int32 bitmask value representing the supported commands.
	// The returned bitmask should be parsed in order to retrieve the supported commands.
	//
	// For instance:
	// - return 0 (\b0)   => [] (GROUP BY is unsupported);
	// - return 1 (\b1)   => [SQL_GROUP_BY_UNRELATED];
	// - return 2 (\b10)  => [SQL_GROUP_BY_BEYOND_SELECT];
	// - return 3 (\b11)  => [SQL_GROUP_BY_UNRELATED, SQL_GROUP_BY_BEYOND_SELECT].
	// Valid GROUP BY types are described under `arrow.flight.protocol.sql.SqlSupportedGroupBy`.
	SqlInfo_SQL_SUPPORTED_GROUP_BY SqlInfo = 522
	//
	// Retrieves a boolean value indicating whether specifying a LIKE escape clause is supported.
	//
	// Returns:
	// - false: if specifying a LIKE escape clause is unsupported;
	// - true: if specifying a LIKE escape clause is supported.
	SqlInfo_SQL_SUPPORTS_LIKE_ESCAPE_CLAUSE SqlInfo = 523
	//
	// Retrieves a boolean value indicating whether columns may be defined as non-nullable.
	//
	// Returns:
	// - false: if columns cannot be defined as non-nullable;
	// - true: if columns may be defined as non-nullable.
	SqlInfo_SQL_SUPPORTS_NON_NULLABLE_COLUMNS SqlInfo = 524
	//
	// Retrieves the supported SQL grammar level as per the ODBC specification.
	//
	// Returns an int32 bitmask value representing the supported SQL grammar level.
	// The returned bitmask should be parsed in order to retrieve the supported grammar levels.
	//
	// For instance:
	// - return 0 (\b0)   => [] (SQL grammar is unsupported);
	// - return 1 (\b1)   => [SQL_MINIMUM_GRAMMAR];
	// - return 2 (\b10)  => [SQL_CORE_GRAMMAR];
	// - return 3 (\b11)  => [SQL_MINIMUM_GRAMMAR, SQL_CORE_GRAMMAR];
	// - return 4 (\b100) => [SQL_EXTENDED_GRAMMAR];
	// - return 5 (\b101) => [SQL_MINIMUM_GRAMMAR, SQL_EXTENDED_GRAMMAR];
	// - return 6 (\b110) => [SQL_CORE_GRAMMAR, SQL_EXTENDED_GRAMMAR];
	// - return 7 (\b111) => [SQL_MINIMUM_GRAMMAR, SQL_CORE_GRAMMAR, SQL_EXTENDED_GRAMMAR].
	// Valid SQL grammar levels are described under `arrow.flight.protocol.sql.SupportedSqlGrammar`.
	SqlInfo_SQL_SUPPORTED_GRAMMAR SqlInfo = 525
	//
	// Retrieves the supported ANSI92 SQL grammar level.
	//
	// Returns an int32 bitmask value representing the supported ANSI92 SQL grammar level.
	// The returned bitmask should be parsed in order to retrieve the supported commands.
	//
	// For instance:
	// - return 0 (\b0)   => [] (ANSI92 SQL grammar is unsupported);
	// - return 1 (\b1)   => [ANSI92_ENTRY_SQL];
	// - return 2 (\b10)  => [ANSI92_INTERMEDIATE_SQL];
	// - return 3 (\b11)  => [ANSI92_ENTRY_SQL, ANSI92_INTERMEDIATE_SQL];
	// - return 4 (\b100) => [ANSI92_FULL_SQL];
	// - return 5 (\b101) => [ANSI92_ENTRY_SQL, ANSI92_FULL_SQL];
	// - return 6 (\b110) => [ANSI92_INTERMEDIATE_SQL, ANSI92_FULL_SQL];
	// - return 7 (\b111) => [ANSI92_ENTRY_SQL, ANSI92_INTERMEDIATE_SQL, ANSI92_FULL_SQL].
	// Valid ANSI92 SQL grammar levels are described under `arrow.flight.protocol.sql.SupportedAnsi92SqlGrammarLevel`.
	SqlInfo_SQL_ANSI92_SUPPORTED_LEVEL SqlInfo = 526
	//
	// Retrieves a boolean value indicating whether the SQL Integrity Enhancement Facility is supported.
	//
	// Returns:
	// - false: if the SQL Integrity Enhancement Facility is supported;
	// - true: if the SQL Integrity Enhancement Facility is supported.
	SqlInfo_SQL_SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY SqlInfo = 527
	//
	// Retrieves the support level for SQL OUTER JOINs.
	//
	// Returns a int32 ordinal for the SQL ordering being used, as described in
	// `arrow.flight.protocol.sql.SqlOuterJoinsSupportLevel`.
	SqlInfo_SQL_OUTER_JOINS_SUPPORT_LEVEL SqlInfo = 528
	// Retrieves a UTF-8 string with the preferred term for "schema".
	SqlInfo_SQL_SCHEMA_TERM SqlInfo = 529
	// Retrieves a UTF-8 string with the preferred term for "procedure".
	SqlInfo_SQL_PROCEDURE_TERM SqlInfo = 530
	//
	// Retrieves a UTF-8 string with the preferred term for "catalog".
	// If a empty string is returned its assumed that the server does NOT supports catalogs.
	SqlInfo_SQL_CATALOG_TERM SqlInfo = 531
	//
	// Retrieves a boolean value indicating whether a catalog appears at the start of a fully qualified table name.
	//
	// - false: if a catalog does not appear at the start of a fully qualified table name;
	// - true: if a catalog appears at the start of a fully qualified table name.
	SqlInfo_SQL_CATALOG_AT_START SqlInfo = 532
	//
	// Retrieves the supported actions for a SQL schema.
	//
	// Returns an int32 bitmask value representing the supported actions for a SQL schema.
	// The returned bitmask should be parsed in order to retrieve the supported actions for a SQL schema.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported actions for SQL schema);
	// - return 1 (\b1)   => [SQL_ELEMENT_IN_PROCEDURE_CALLS];
	// - return 2 (\b10)  => [SQL_ELEMENT_IN_INDEX_DEFINITIONS];
	// - return 3 (\b11)  => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS];
	// - return 4 (\b100) => [SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
	// - return 5 (\b101) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
	// - return 6 (\b110) => [SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
	// - return 7 (\b111) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS].
	// Valid actions for a SQL schema described under `arrow.flight.protocol.sql.SqlSupportedElementActions`.
	SqlInfo_SQL_SCHEMAS_SUPPORTED_ACTIONS SqlInfo = 533
	//
	// Retrieves the supported actions for a SQL schema.
	//
	// Returns an int32 bitmask value representing the supported actions for a SQL catalog.
	// The returned bitmask should be parsed in order to retrieve the supported actions for a SQL catalog.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported actions for SQL catalog);
	// - return 1 (\b1)   => [SQL_ELEMENT_IN_PROCEDURE_CALLS];
	// - return 2 (\b10)  => [SQL_ELEMENT_IN_INDEX_DEFINITIONS];
	// - return 3 (\b11)  => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS];
	// - return 4 (\b100) => [SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
	// - return 5 (\b101) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
	// - return 6 (\b110) => [SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
	// - return 7 (\b111) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS].
	// Valid actions for a SQL catalog are described under `arrow.flight.protocol.sql.SqlSupportedElementActions`.
	SqlInfo_SQL_CATALOGS_SUPPORTED_ACTIONS SqlInfo = 534
	//
	// Retrieves the supported SQL positioned commands.
	//
	// Returns an int32 bitmask value representing the supported SQL positioned commands.
	// The returned bitmask should be parsed in order to retrieve the supported SQL positioned commands.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported SQL positioned commands);
	// - return 1 (\b1)   => [SQL_POSITIONED_DELETE];
	// - return 2 (\b10)  => [SQL_POSITIONED_UPDATE];
	// - return 3 (\b11)  => [SQL_POSITIONED_DELETE, SQL_POSITIONED_UPDATE].
	// Valid SQL positioned commands are described under `arrow.flight.protocol.sql.SqlSupportedPositionedCommands`.
	SqlInfo_SQL_SUPPORTED_POSITIONED_COMMANDS SqlInfo = 535
	//
	// Retrieves a boolean value indicating whether SELECT FOR UPDATE statements are supported.
	//
	// Returns:
	// - false: if SELECT FOR UPDATE statements are unsupported;
	// - true: if SELECT FOR UPDATE statements are supported.
	SqlInfo_SQL_SELECT_FOR_UPDATE_SUPPORTED SqlInfo = 536
	//
	// Retrieves a boolean value indicating whether stored procedure calls that use the stored procedure escape syntax
	// are supported.
	//
	// Returns:
	// - false: if stored procedure calls that use the stored procedure escape syntax are unsupported;
	// - true: if stored procedure calls that use the stored procedure escape syntax are supported.
	SqlInfo_SQL_STORED_PROCEDURES_SUPPORTED SqlInfo = 537
	//
	// Retrieves the supported SQL subqueries.
	//
	// Returns an int32 bitmask value representing the supported SQL subqueries.
	// The returned bitmask should be parsed in order to retrieve the supported SQL subqueries.
	//
	// For instance:
	// - return 0   (\b0)     => [] (no supported SQL subqueries);
	// - return 1   (\b1)     => [SQL_SUBQUERIES_IN_COMPARISONS];
	// - return 2   (\b10)    => [SQL_SUBQUERIES_IN_EXISTS];
	// - return 3   (\b11)    => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS];
	// - return 4   (\b100)   => [SQL_SUBQUERIES_IN_INS];
	// - return 5   (\b101)   => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_INS];
	// - return 6   (\b110)   => [SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_EXISTS];
	// - return 7   (\b111)   => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_INS];
	// - return 8   (\b1000)  => [SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 9   (\b1001)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 10  (\b1010)  => [SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 11  (\b1011)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 12  (\b1100)  => [SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 13  (\b1101)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 14  (\b1110)  => [SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - return 15  (\b1111)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
	// - ...
	// Valid SQL subqueries are described under `arrow.flight.protocol.sql.SqlSupportedSubqueries`.
	SqlInfo_SQL_SUPPORTED_SUBQUERIES SqlInfo = 538
	//
	// Retrieves a boolean value indicating whether correlated subqueries are supported.
	//
	// Returns:
	// - false: if correlated subqueries are unsupported;
	// - true: if correlated subqueries are supported.
	SqlInfo_SQL_CORRELATED_SUBQUERIES_SUPPORTED SqlInfo = 539
	//
	// Retrieves the supported SQL UNIONs.
	//
	// Returns an int32 bitmask value representing the supported SQL UNIONs.
	// The returned bitmask should be parsed in order to retrieve the supported SQL UNIONs.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported SQL positioned commands);
	// - return 1 (\b1)   => [SQL_UNION];
	// - return 2 (\b10)  => [SQL_UNION_ALL];
	// - return 3 (\b11)  => [SQL_UNION, SQL_UNION_ALL].
	// Valid SQL positioned commands are described under `arrow.flight.protocol.sql.SqlSupportedUnions`.
	SqlInfo_SQL_SUPPORTED_UNIONS SqlInfo = 540
	// Retrieves a int64 value representing the maximum number of hex characters allowed in an inline binary literal.
	SqlInfo_SQL_MAX_BINARY_LITERAL_LENGTH SqlInfo = 541
	// Retrieves a int64 value representing the maximum number of characters allowed for a character literal.
	SqlInfo_SQL_MAX_CHAR_LITERAL_LENGTH SqlInfo = 542
	// Retrieves a int64 value representing the maximum number of characters allowed for a column name.
	SqlInfo_SQL_MAX_COLUMN_NAME_LENGTH SqlInfo = 543
	// Retrieves a int64 value representing the maximum number of columns allowed in a GROUP BY clause.
	SqlInfo_SQL_MAX_COLUMNS_IN_GROUP_BY SqlInfo = 544
	// Retrieves a int64 value representing the maximum number of columns allowed in an index.
	SqlInfo_SQL_MAX_COLUMNS_IN_INDEX SqlInfo = 545
	// Retrieves a int64 value representing the maximum number of columns allowed in an ORDER BY clause.
	SqlInfo_SQL_MAX_COLUMNS_IN_ORDER_BY SqlInfo = 546
	// Retrieves a int64 value representing the maximum number of columns allowed in a SELECT list.
	SqlInfo_SQL_MAX_COLUMNS_IN_SELECT SqlInfo = 547
	// Retrieves a int64 value representing the maximum number of columns allowed in a table.
	SqlInfo_SQL_MAX_COLUMNS_IN_TABLE SqlInfo = 548
	// Retrieves a int64 value representing the maximum number of concurrent connections possible.
	SqlInfo_SQL_MAX_CONNECTIONS SqlInfo = 549
	// Retrieves a int64 value the maximum number of characters allowed in a cursor name.
	SqlInfo_SQL_MAX_CURSOR_NAME_LENGTH SqlInfo = 550
	//
	// Retrieves a int64 value representing the maximum number of bytes allowed for an index,
	// including all of the parts of the index.
	SqlInfo_SQL_MAX_INDEX_LENGTH SqlInfo = 551
	// Retrieves a int64 value representing the maximum number of characters allowed in a schema name.
	SqlInfo_SQL_DB_SCHEMA_NAME_LENGTH SqlInfo = 552
	// Retrieves a int64 value representing the maximum number of characters allowed in a procedure name.
	SqlInfo_SQL_MAX_PROCEDURE_NAME_LENGTH SqlInfo = 553
	// Retrieves a int64 value representing the maximum number of characters allowed in a catalog name.
	SqlInfo_SQL_MAX_CATALOG_NAME_LENGTH SqlInfo = 554
	// Retrieves a int64 value representing the maximum number of bytes allowed in a single row.
	SqlInfo_SQL_MAX_ROW_SIZE SqlInfo = 555
	//
	// Retrieves a boolean indicating whether the return value for the JDBC method getMaxRowSize includes the SQL
	// data types LONGVARCHAR and LONGVARBINARY.
	//
	// Returns:
	// - false: if return value for the JDBC method getMaxRowSize does
	//          not include the SQL data types LONGVARCHAR and LONGVARBINARY;
	// - true: if return value for the JDBC method getMaxRowSize includes
	//         the SQL data types LONGVARCHAR and LONGVARBINARY.
	SqlInfo_SQL_MAX_ROW_SIZE_INCLUDES_BLOBS SqlInfo = 556
	//
	// Retrieves a int64 value representing the maximum number of characters allowed for an SQL statement;
	// a result of 0 (zero) means that there is no limit or the limit is not known.
	SqlInfo_SQL_MAX_STATEMENT_LENGTH SqlInfo = 557
	// Retrieves a int64 value representing the maximum number of active statements that can be open at the same time.
	SqlInfo_SQL_MAX_STATEMENTS SqlInfo = 558
	// Retrieves a int64 value representing the maximum number of characters allowed in a table name.
	SqlInfo_SQL_MAX_TABLE_NAME_LENGTH SqlInfo = 559
	// Retrieves a int64 value representing the maximum number of tables allowed in a SELECT statement.
	SqlInfo_SQL_MAX_TABLES_IN_SELECT SqlInfo = 560
	// Retrieves a int64 value representing the maximum number of characters allowed in a user name.
	SqlInfo_SQL_MAX_USERNAME_LENGTH SqlInfo = 561
	//
	// Retrieves this database's default transaction isolation level as described in
	// `arrow.flight.protocol.sql.SqlTransactionIsolationLevel`.
	//
	// Returns a int32 ordinal for the SQL transaction isolation level.
	SqlInfo_SQL_DEFAULT_TRANSACTION_ISOLATION SqlInfo = 562
	//
	// Retrieves a boolean value indicating whether transactions are supported. If not, invoking the method commit is a
	// noop, and the isolation level is `arrow.flight.protocol.sql.SqlTransactionIsolationLevel.TRANSACTION_NONE`.
	//
	// Returns:
	// - false: if transactions are unsupported;
	// - true: if transactions are supported.
	SqlInfo_SQL_TRANSACTIONS_SUPPORTED SqlInfo = 563
	//
	// Retrieves the supported transactions isolation levels.
	//
	// Returns an int32 bitmask value representing the supported transactions isolation levels.
	// The returned bitmask should be parsed in order to retrieve the supported transactions isolation levels.
	//
	// For instance:
	// - return 0   (\b0)     => [] (no supported SQL transactions isolation levels);
	// - return 1   (\b1)     => [SQL_TRANSACTION_NONE];
	// - return 2   (\b10)    => [SQL_TRANSACTION_READ_UNCOMMITTED];
	// - return 3   (\b11)    => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED];
	// - return 4   (\b100)   => [SQL_TRANSACTION_REPEATABLE_READ];
	// - return 5   (\b101)   => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 6   (\b110)   => [SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 7   (\b111)   => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 8   (\b1000)  => [SQL_TRANSACTION_REPEATABLE_READ];
	// - return 9   (\b1001)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 10  (\b1010)  => [SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 11  (\b1011)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 12  (\b1100)  => [SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 13  (\b1101)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 14  (\b1110)  => [SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 15  (\b1111)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
	// - return 16  (\b10000) => [SQL_TRANSACTION_SERIALIZABLE];
	// - ...
	// Valid SQL positioned commands are described under `arrow.flight.protocol.sql.SqlTransactionIsolationLevel`.
	SqlInfo_SQL_SUPPORTED_TRANSACTIONS_ISOLATION_LEVELS SqlInfo = 564
	//
	// Retrieves a boolean value indicating whether a data definition statement within a transaction forces
	// the transaction to commit.
	//
	// Returns:
	// - false: if a data definition statement within a transaction does not force the transaction to commit;
	// - true: if a data definition statement within a transaction forces the transaction to commit.
	SqlInfo_SQL_DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT SqlInfo = 565
	//
	// Retrieves a boolean value indicating whether a data definition statement within a transaction is ignored.
	//
	// Returns:
	// - false: if a data definition statement within a transaction is taken into account;
	// - true: a data definition statement within a transaction is ignored.
	SqlInfo_SQL_DATA_DEFINITIONS_IN_TRANSACTIONS_IGNORED SqlInfo = 566
	//
	// Retrieves an int32 bitmask value representing the supported result set types.
	// The returned bitmask should be parsed in order to retrieve the supported result set types.
	//
	// For instance:
	// - return 0   (\b0)     => [] (no supported result set types);
	// - return 1   (\b1)     => [SQL_RESULT_SET_TYPE_UNSPECIFIED];
	// - return 2   (\b10)    => [SQL_RESULT_SET_TYPE_FORWARD_ONLY];
	// - return 3   (\b11)    => [SQL_RESULT_SET_TYPE_UNSPECIFIED, SQL_RESULT_SET_TYPE_FORWARD_ONLY];
	// - return 4   (\b100)   => [SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
	// - return 5   (\b101)   => [SQL_RESULT_SET_TYPE_UNSPECIFIED, SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
	// - return 6   (\b110)   => [SQL_RESULT_SET_TYPE_FORWARD_ONLY, SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
	// - return 7   (\b111)   => [SQL_RESULT_SET_TYPE_UNSPECIFIED, SQL_RESULT_SET_TYPE_FORWARD_ONLY, SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
	// - return 8   (\b1000)  => [SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE];
	// - ...
	// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetType`.
	SqlInfo_SQL_SUPPORTED_RESULT_SET_TYPES SqlInfo = 567
	//
	// Returns an int32 bitmask value concurrency types supported for
	// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_UNSPECIFIED`.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
	// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
	// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
	SqlInfo_SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_UNSPECIFIED SqlInfo = 568
	//
	// Returns an int32 bitmask value concurrency types supported for
	// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_FORWARD_ONLY`.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
	// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
	// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
	SqlInfo_SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_FORWARD_ONLY SqlInfo = 569
	//
	// Returns an int32 bitmask value concurrency types supported for
	// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE`.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
	// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
	// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
	SqlInfo_SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_SENSITIVE SqlInfo = 570
	//
	// Returns an int32 bitmask value concurrency types supported for
	// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE`.
	//
	// For instance:
	// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
	// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
	// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
	// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
	// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
	SqlInfo_SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_INSENSITIVE SqlInfo = 571
	//
	// Retrieves a boolean value indicating whether this database supports batch updates.
	//
	// - false: if this database does not support batch updates;
	// - true: if this database supports batch updates.
	SqlInfo_SQL_BATCH_UPDATES_SUPPORTED SqlInfo = 572
	//
	// Retrieves a boolean value indicating whether this database supports savepoints.
	//
	// Returns:
	// - false: if this database does not support savepoints;
	// - true: if this database supports savepoints.
	SqlInfo_SQL_SAVEPOINTS_SUPPORTED SqlInfo = 573
	//
	// Retrieves a boolean value indicating whether named parameters are supported in callable statements.
	//
	// Returns:
	// - false: if named parameters in callable statements are unsupported;
	// - true: if named parameters in callable statements are supported.
	SqlInfo_SQL_NAMED_PARAMETERS_SUPPORTED SqlInfo = 574
	//
	// Retrieves a boolean value indicating whether updates made to a LOB are made on a copy or directly to the LOB.
	//
	// Returns:
	// - false: if updates made to a LOB are made directly to the LOB;
	// - true: if updates made to a LOB are made on a copy.
	SqlInfo_SQL_LOCATORS_UPDATE_COPY SqlInfo = 575
	//
	// Retrieves a boolean value indicating whether invoking user-defined or vendor functions
	// using the stored procedure escape syntax is supported.
	//
	// Returns:
	// - false: if invoking user-defined or vendor functions using the stored procedure escape syntax is unsupported;
	// - true: if invoking user-defined or vendor functions using the stored procedure escape syntax is supported.
	SqlInfo_SQL_STORED_FUNCTIONS_USING_CALL_SYNTAX_SUPPORTED SqlInfo = 576
)

// Enum value maps for SqlInfo.
var (
	SqlInfo_name = map[int32]string{
		0:   "FLIGHT_SQL_SERVER_NAME",
		1:   "FLIGHT_SQL_SERVER_VERSION",
		2:   "FLIGHT_SQL_SERVER_ARROW_VERSION",
		3:   "FLIGHT_SQL_SERVER_READ_ONLY",
		4:   "FLIGHT_SQL_SERVER_SQL",
		5:   "FLIGHT_SQL_SERVER_SUBSTRAIT",
		6:   "FLIGHT_SQL_SERVER_SUBSTRAIT_MIN_VERSION",
		7:   "FLIGHT_SQL_SERVER_SUBSTRAIT_MAX_VERSION",
		8:   "FLIGHT_SQL_SERVER_TRANSACTION",
		9:   "FLIGHT_SQL_SERVER_CANCEL",
		100: "FLIGHT_SQL_SERVER_STATEMENT_TIMEOUT",
		101: "FLIGHT_SQL_SERVER_TRANSACTION_TIMEOUT",
		500: "SQL_DDL_CATALOG",
		501: "SQL_DDL_SCHEMA",
		502: "SQL_DDL_TABLE",
		503: "SQL_IDENTIFIER_CASE",
		504: "SQL_IDENTIFIER_QUOTE_CHAR",
		505: "SQL_QUOTED_IDENTIFIER_CASE",
		506: "SQL_ALL_TABLES_ARE_SELECTABLE",
		507: "SQL_NULL_ORDERING",
		508: "SQL_KEYWORDS",
		509: "SQL_NUMERIC_FUNCTIONS",
		510: "SQL_STRING_FUNCTIONS",
		511: "SQL_SYSTEM_FUNCTIONS",
		512: "SQL_DATETIME_FUNCTIONS",
		513: "SQL_SEARCH_STRING_ESCAPE",
		514: "SQL_EXTRA_NAME_CHARACTERS",
		515: "SQL_SUPPORTS_COLUMN_ALIASING",
		516: "SQL_NULL_PLUS_NULL_IS_NULL",
		517: "SQL_SUPPORTS_CONVERT",
		518: "SQL_SUPPORTS_TABLE_CORRELATION_NAMES",
		519: "SQL_SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES",
		520: "SQL_SUPPORTS_EXPRESSIONS_IN_ORDER_BY",
		521: "SQL_SUPPORTS_ORDER_BY_UNRELATED",
		522: "SQL_SUPPORTED_GROUP_BY",
		523: "SQL_SUPPORTS_LIKE_ESCAPE_CLAUSE",
		524: "SQL_SUPPORTS_NON_NULLABLE_COLUMNS",
		525: "SQL_SUPPORTED_GRAMMAR",
		526: "SQL_ANSI92_SUPPORTED_LEVEL",
		527: "SQL_SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY",
		528: "SQL_OUTER_JOINS_SUPPORT_LEVEL",
		529: "SQL_SCHEMA_TERM",
		530: "SQL_PROCEDURE_TERM",
		531: "SQL_CATALOG_TERM",
		532: "SQL_CATALOG_AT_START",
		533: "SQL_SCHEMAS_SUPPORTED_ACTIONS",
		534: "SQL_CATALOGS_SUPPORTED_ACTIONS",
		535: "SQL_SUPPORTED_POSITIONED_COMMANDS",
		536: "SQL_SELECT_FOR_UPDATE_SUPPORTED",
		537: "SQL_STORED_PROCEDURES_SUPPORTED",
		538: "SQL_SUPPORTED_SUBQUERIES",
		539: "SQL_CORRELATED_SUBQUERIES_SUPPORTED",
		540: "SQL_SUPPORTED_UNIONS",
		541: "SQL_MAX_BINARY_LITERAL_LENGTH",
		542: "SQL_MAX_CHAR_LITERAL_LENGTH",
		543: "SQL_MAX_COLUMN_NAME_LENGTH",
		544: "SQL_MAX_COLUMNS_IN_GROUP_BY",
		545: "SQL_MAX_COLUMNS_IN_INDEX",
		546: "SQL_MAX_COLUMNS_IN_ORDER_BY",
		547: "SQL_MAX_COLUMNS_IN_SELECT",
		548: "SQL_MAX_COLUMNS_IN_TABLE",
		549: "SQL_MAX_CONNECTIONS",
		550: "SQL_MAX_CURSOR_NAME_LENGTH",
		551: "SQL_MAX_INDEX_LENGTH",
		552: "SQL_DB_SCHEMA_NAME_LENGTH",
		553: "SQL_MAX_PROCEDURE_NAME_LENGTH",
		554: "SQL_MAX_CATALOG_NAME_LENGTH",
		555: "SQL_MAX_ROW_SIZE",
		556: "SQL_MAX_ROW_SIZE_INCLUDES_BLOBS",
		557: "SQL_MAX_STATEMENT_LENGTH",
		558: "SQL_MAX_STATEMENTS",
		559: "SQL_MAX_TABLE_NAME_LENGTH",
		560: "SQL_MAX_TABLES_IN_SELECT",
		561: "SQL_MAX_USERNAME_LENGTH",
		562: "SQL_DEFAULT_TRANSACTION_ISOLATION",
		563: "SQL_TRANSACTIONS_SUPPORTED",
		564: "SQL_SUPPORTED_TRANSACTIONS_ISOLATION_LEVELS",
		565: "SQL_DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT",
		566: "SQL_DATA_DEFINITIONS_IN_TRANSACTIONS_IGNORED",
		567: "SQL_SUPPORTED_RESULT_SET_TYPES",
		568: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_UNSPECIFIED",
		569: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_FORWARD_ONLY",
		570: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_SENSITIVE",
		571: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_INSENSITIVE",
		572: "SQL_BATCH_UPDATES_SUPPORTED",
		573: "SQL_SAVEPOINTS_SUPPORTED",
		574: "SQL_NAMED_PARAMETERS_SUPPORTED",
		575: "SQL_LOCATORS_UPDATE_COPY",
		576: "SQL_STORED_FUNCTIONS_USING_CALL_SYNTAX_SUPPORTED",
	}
	SqlInfo_value = map[string]int32{
		"FLIGHT_SQL_SERVER_NAME":                                        0,
		"FLIGHT_SQL_SERVER_VERSION":                                     1,
		"FLIGHT_SQL_SERVER_ARROW_VERSION":                               2,
		"FLIGHT_SQL_SERVER_READ_ONLY":                                   3,
		"FLIGHT_SQL_SERVER_SQL":                                         4,
		"FLIGHT_SQL_SERVER_SUBSTRAIT":                                   5,
		"FLIGHT_SQL_SERVER_SUBSTRAIT_MIN_VERSION":                       6,
		"FLIGHT_SQL_SERVER_SUBSTRAIT_MAX_VERSION":                       7,
		"FLIGHT_SQL_SERVER_TRANSACTION":                                 8,
		"FLIGHT_SQL_SERVER_CANCEL":                                      9,
		"FLIGHT_SQL_SERVER_STATEMENT_TIMEOUT":                           100,
		"FLIGHT_SQL_SERVER_TRANSACTION_TIMEOUT":                         101,
		"SQL_DDL_CATALOG":                                               500,
		"SQL_DDL_SCHEMA":                                                501,
		"SQL_DDL_TABLE":                                                 502,
		"SQL_IDENTIFIER_CASE":                                           503,
		"SQL_IDENTIFIER_QUOTE_CHAR":                                     504,
		"SQL_QUOTED_IDENTIFIER_CASE":                                    505,
		"SQL_ALL_TABLES_ARE_SELECTABLE":                                 506,
		"SQL_NULL_ORDERING":                                             507,
		"SQL_KEYWORDS":                                                  508,
		"SQL_NUMERIC_FUNCTIONS":                                         509,
		"SQL_STRING_FUNCTIONS":                                          510,
		"SQL_SYSTEM_FUNCTIONS":                                          511,
		"SQL_DATETIME_FUNCTIONS":                                        512,
		"SQL_SEARCH_STRING_ESCAPE":                                      513,
		"SQL_EXTRA_NAME_CHARACTERS":                                     514,
		"SQL_SUPPORTS_COLUMN_ALIASING":                                  515,
		"SQL_NULL_PLUS_NULL_IS_NULL":                                    516,
		"SQL_SUPPORTS_CONVERT":                                          517,
		"SQL_SUPPORTS_TABLE_CORRELATION_NAMES":                          518,
		"SQL_SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES":                519,
		"SQL_SUPPORTS_EXPRESSIONS_IN_ORDER_BY":                          520,
		"SQL_SUPPORTS_ORDER_BY_UNRELATED":                               521,
		"SQL_SUPPORTED_GROUP_BY":                                        522,
		"SQL_SUPPORTS_LIKE_ESCAPE_CLAUSE":                               523,
		"SQL_SUPPORTS_NON_NULLABLE_COLUMNS":                             524,
		"SQL_SUPPORTED_GRAMMAR":                                         525,
		"SQL_ANSI92_SUPPORTED_LEVEL":                                    526,
		"SQL_SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY":                   527,
		"SQL_OUTER_JOINS_SUPPORT_LEVEL":                                 528,
		"SQL_SCHEMA_TERM":                                               529,
		"SQL_PROCEDURE_TERM":                                            530,
		"SQL_CATALOG_TERM":                                              531,
		"SQL_CATALOG_AT_START":                                          532,
		"SQL_SCHEMAS_SUPPORTED_ACTIONS":                                 533,
		"SQL_CATALOGS_SUPPORTED_ACTIONS":                                534,
		"SQL_SUPPORTED_POSITIONED_COMMANDS":                             535,
		"SQL_SELECT_FOR_UPDATE_SUPPORTED":                               536,
		"SQL_STORED_PROCEDURES_SUPPORTED":                               537,
		"SQL_SUPPORTED_SUBQUERIES":                                      538,
		"SQL_CORRELATED_SUBQUERIES_SUPPORTED":                           539,
		"SQL_SUPPORTED_UNIONS":                                          540,
		"SQL_MAX_BINARY_LITERAL_LENGTH":                                 541,
		"SQL_MAX_CHAR_LITERAL_LENGTH":                                   542,
		"SQL_MAX_COLUMN_NAME_LENGTH":                                    543,
		"SQL_MAX_COLUMNS_IN_GROUP_BY":                                   544,
		"SQL_MAX_COLUMNS_IN_INDEX":                                      545,
		"SQL_MAX_COLUMNS_IN_ORDER_BY":                                   546,
		"SQL_MAX_COLUMNS_IN_SELECT":                                     547,
		"SQL_MAX_COLUMNS_IN_TABLE":                                      548,
		"SQL_MAX_CONNECTIONS":                                           549,
		"SQL_MAX_CURSOR_NAME_LENGTH":                                    550,
		"SQL_MAX_INDEX_LENGTH":                                          551,
		"SQL_DB_SCHEMA_NAME_LENGTH":                                     552,
		"SQL_MAX_PROCEDURE_NAME_LENGTH":                                 553,
		"SQL_MAX_CATALOG_NAME_LENGTH":                                   554,
		"SQL_MAX_ROW_SIZE":                                              555,
		"SQL_MAX_ROW_SIZE_INCLUDES_BLOBS":                               556,
		"SQL_MAX_STATEMENT_LENGTH":                                      557,
		"SQL_MAX_STATEMENTS":                                            558,
		"SQL_MAX_TABLE_NAME_LENGTH":                                     559,
		"SQL_MAX_TABLES_IN_SELECT":                                      560,
		"SQL_MAX_USERNAME_LENGTH":                                       561,
		"SQL_DEFAULT_TRANSACTION_ISOLATION":                             562,
		"SQL_TRANSACTIONS_SUPPORTED":                                    563,
		"SQL_SUPPORTED_TRANSACTIONS_ISOLATION_LEVELS":                   564,
		"SQL_DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT":                 565,
		"SQL_DATA_DEFINITIONS_IN_TRANSACTIONS_IGNORED":                  566,
		"SQL_SUPPORTED_RESULT_SET_TYPES":                                567,
		"SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_UNSPECIFIED":        568,
		"SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_FORWARD_ONLY":       569,
		"SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_SENSITIVE":   570,
		"SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_INSENSITIVE": 571,
		"SQL_BATCH_UPDATES_SUPPORTED":                                   572,
		"SQL_SAVEPOINTS_SUPPORTED":                                      573,
		"SQL_NAMED_PARAMETERS_SUPPORTED":                                574,
		"SQL_LOCATORS_UPDATE_COPY":                                      575,
		"SQL_STORED_FUNCTIONS_USING_CALL_SYNTAX_SUPPORTED":              576,
	}
)

func (x SqlInfo) Enum() *SqlInfo {
	p := new(SqlInfo)
	*p = x
	return p
}

func (x SqlInfo) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInfo) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[0].Descriptor()
}

func (SqlInfo) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[0]
}

func (x SqlInfo) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInfo.Descriptor instead.
func (SqlInfo) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{0}
}

// The level of support for Flight SQL transaction RPCs.
type SqlSupportedTransaction int32

const (
	// Unknown/not indicated/no support
	SqlSupportedTransaction_SQL_SUPPORTED_TRANSACTION_NONE SqlSupportedTransaction = 0
	// Transactions, but not savepoints.
	// A savepoint is a mark within a transaction that can be individually
	// rolled back to. Not all databases support savepoints.
	SqlSupportedTransaction_SQL_SUPPORTED_TRANSACTION_TRANSACTION SqlSupportedTransaction = 1
	// Transactions and savepoints
	SqlSupportedTransaction_SQL_SUPPORTED_TRANSACTION_SAVEPOINT SqlSupportedTransaction = 2
)

// Enum value maps for SqlSupportedTransaction.
var (
	SqlSupportedTransaction_name = map[int32]string{
		0: "SQL_SUPPORTED_TRANSACTION_NONE",
		1: "SQL_SUPPORTED_TRANSACTION_TRANSACTION",
		2: "SQL_SUPPORTED_TRANSACTION_SAVEPOINT",
	}
	SqlSupportedTransaction_value = map[string]int32{
		"SQL_SUPPORTED_TRANSACTION_NONE":        0,
		"SQL_SUPPORTED_TRANSACTION_TRANSACTION": 1,
		"SQL_SUPPORTED_TRANSACTION_SAVEPOINT":   2,
	}
)

func (x SqlSupportedTransaction) Enum() *SqlSupportedTransaction {
	p := new(SqlSupportedTransaction)
	*p = x
	return p
}

func (x SqlSupportedTransaction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedTransaction) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[1].Descriptor()
}

func (SqlSupportedTransaction) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[1]
}

func (x SqlSupportedTransaction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedTransaction.Descriptor instead.
func (SqlSupportedTransaction) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{1}
}

type SqlSupportedCaseSensitivity int32

const (
	SqlSupportedCaseSensitivity_SQL_CASE_SENSITIVITY_UNKNOWN          SqlSupportedCaseSensitivity = 0
	SqlSupportedCaseSensitivity_SQL_CASE_SENSITIVITY_CASE_INSENSITIVE SqlSupportedCaseSensitivity = 1
	SqlSupportedCaseSensitivity_SQL_CASE_SENSITIVITY_UPPERCASE        SqlSupportedCaseSensitivity = 2
	SqlSupportedCaseSensitivity_SQL_CASE_SENSITIVITY_LOWERCASE        SqlSupportedCaseSensitivity = 3
)

// Enum value maps for SqlSupportedCaseSensitivity.
var (
	SqlSupportedCaseSensitivity_name = map[int32]string{
		0: "SQL_CASE_SENSITIVITY_UNKNOWN",
		1: "SQL_CASE_SENSITIVITY_CASE_INSENSITIVE",
		2: "SQL_CASE_SENSITIVITY_UPPERCASE",
		3: "SQL_CASE_SENSITIVITY_LOWERCASE",
	}
	SqlSupportedCaseSensitivity_value = map[string]int32{
		"SQL_CASE_SENSITIVITY_UNKNOWN":          0,
		"SQL_CASE_SENSITIVITY_CASE_INSENSITIVE": 1,
		"SQL_CASE_SENSITIVITY_UPPERCASE":        2,
		"SQL_CASE_SENSITIVITY_LOWERCASE":        3,
	}
)

func (x SqlSupportedCaseSensitivity) Enum() *SqlSupportedCaseSensitivity {
	p := new(SqlSupportedCaseSensitivity)
	*p = x
	return p
}

func (x SqlSupportedCaseSensitivity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedCaseSensitivity) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[2].Descriptor()
}

func (SqlSupportedCaseSensitivity) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[2]
}

func (x SqlSupportedCaseSensitivity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedCaseSensitivity.Descriptor instead.
func (SqlSupportedCaseSensitivity) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{2}
}

type SqlNullOrdering int32

const (
	SqlNullOrdering_SQL_NULLS_SORTED_HIGH     SqlNullOrdering = 0
	SqlNullOrdering_SQL_NULLS_SORTED_LOW      SqlNullOrdering = 1
	SqlNullOrdering_SQL_NULLS_SORTED_AT_START SqlNullOrdering = 2
	SqlNullOrdering_SQL_NULLS_SORTED_AT_END   SqlNullOrdering = 3
)

// Enum value maps for SqlNullOrdering.
var (
	SqlNullOrdering_name = map[int32]string{
		0: "SQL_NULLS_SORTED_HIGH",
		1: "SQL_NULLS_SORTED_LOW",
		2: "SQL_NULLS_SORTED_AT_START",
		3: "SQL_NULLS_SORTED_AT_END",
	}
	SqlNullOrdering_value = map[string]int32{
		"SQL_NULLS_SORTED_HIGH":     0,
		"SQL_NULLS_SORTED_LOW":      1,
		"SQL_NULLS_SORTED_AT_START": 2,
		"SQL_NULLS_SORTED_AT_END":   3,
	}
)

func (x SqlNullOrdering) Enum() *SqlNullOrdering {
	p := new(SqlNullOrdering)
	*p = x
	return p
}

func (x SqlNullOrdering) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlNullOrdering) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[3].Descriptor()
}

func (SqlNullOrdering) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[3]
}

func (x SqlNullOrdering) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlNullOrdering.Descriptor instead.
func (SqlNullOrdering) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{3}
}

type SupportedSqlGrammar int32

const (
	SupportedSqlGrammar_SQL_MINIMUM_GRAMMAR  SupportedSqlGrammar = 0
	SupportedSqlGrammar_SQL_CORE_GRAMMAR     SupportedSqlGrammar = 1
	SupportedSqlGrammar_SQL_EXTENDED_GRAMMAR SupportedSqlGrammar = 2
)

// Enum value maps for SupportedSqlGrammar.
var (
	SupportedSqlGrammar_name = map[int32]string{
		0: "SQL_MINIMUM_GRAMMAR",
		1: "SQL_CORE_GRAMMAR",
		2: "SQL_EXTENDED_GRAMMAR",
	}
	SupportedSqlGrammar_value = map[string]int32{
		"SQL_MINIMUM_GRAMMAR":  0,
		"SQL_CORE_GRAMMAR":     1,
		"SQL_EXTENDED_GRAMMAR": 2,
	}
)

func (x SupportedSqlGrammar) Enum() *SupportedSqlGrammar {
	p := new(SupportedSqlGrammar)
	*p = x
	return p
}

func (x SupportedSqlGrammar) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupportedSqlGrammar) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[4].Descriptor()
}

func (SupportedSqlGrammar) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[4]
}

func (x SupportedSqlGrammar) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupportedSqlGrammar.Descriptor instead.
func (SupportedSqlGrammar) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{4}
}

type SupportedAnsi92SqlGrammarLevel int32

const (
	SupportedAnsi92SqlGrammarLevel_ANSI92_ENTRY_SQL        SupportedAnsi92SqlGrammarLevel = 0
	SupportedAnsi92SqlGrammarLevel_ANSI92_INTERMEDIATE_SQL SupportedAnsi92SqlGrammarLevel = 1
	SupportedAnsi92SqlGrammarLevel_ANSI92_FULL_SQL         SupportedAnsi92SqlGrammarLevel = 2
)

// Enum value maps for SupportedAnsi92SqlGrammarLevel.
var (
	SupportedAnsi92SqlGrammarLevel_name = map[int32]string{
		0: "ANSI92_ENTRY_SQL",
		1: "ANSI92_INTERMEDIATE_SQL",
		2: "ANSI92_FULL_SQL",
	}
	SupportedAnsi92SqlGrammarLevel_value = map[string]int32{
		"ANSI92_ENTRY_SQL":        0,
		"ANSI92_INTERMEDIATE_SQL": 1,
		"ANSI92_FULL_SQL":         2,
	}
)

func (x SupportedAnsi92SqlGrammarLevel) Enum() *SupportedAnsi92SqlGrammarLevel {
	p := new(SupportedAnsi92SqlGrammarLevel)
	*p = x
	return p
}

func (x SupportedAnsi92SqlGrammarLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupportedAnsi92SqlGrammarLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[5].Descriptor()
}

func (SupportedAnsi92SqlGrammarLevel) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[5]
}

func (x SupportedAnsi92SqlGrammarLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupportedAnsi92SqlGrammarLevel.Descriptor instead.
func (SupportedAnsi92SqlGrammarLevel) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{5}
}

type SqlOuterJoinsSupportLevel int32

const (
	SqlOuterJoinsSupportLevel_SQL_JOINS_UNSUPPORTED   SqlOuterJoinsSupportLevel = 0
	SqlOuterJoinsSupportLevel_SQL_LIMITED_OUTER_JOINS SqlOuterJoinsSupportLevel = 1
	SqlOuterJoinsSupportLevel_SQL_FULL_OUTER_JOINS    SqlOuterJoinsSupportLevel = 2
)

// Enum value maps for SqlOuterJoinsSupportLevel.
var (
	SqlOuterJoinsSupportLevel_name = map[int32]string{
		0: "SQL_JOINS_UNSUPPORTED",
		1: "SQL_LIMITED_OUTER_JOINS",
		2: "SQL_FULL_OUTER_JOINS",
	}
	SqlOuterJoinsSupportLevel_value = map[string]int32{
		"SQL_JOINS_UNSUPPORTED":   0,
		"SQL_LIMITED_OUTER_JOINS": 1,
		"SQL_FULL_OUTER_JOINS":    2,
	}
)

func (x SqlOuterJoinsSupportLevel) Enum() *SqlOuterJoinsSupportLevel {
	p := new(SqlOuterJoinsSupportLevel)
	*p = x
	return p
}

func (x SqlOuterJoinsSupportLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlOuterJoinsSupportLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[6].Descriptor()
}

func (SqlOuterJoinsSupportLevel) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[6]
}

func (x SqlOuterJoinsSupportLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlOuterJoinsSupportLevel.Descriptor instead.
func (SqlOuterJoinsSupportLevel) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{6}
}

type SqlSupportedGroupBy int32

const (
	SqlSupportedGroupBy_SQL_GROUP_BY_UNRELATED     SqlSupportedGroupBy = 0
	SqlSupportedGroupBy_SQL_GROUP_BY_BEYOND_SELECT SqlSupportedGroupBy = 1
)

// Enum value maps for SqlSupportedGroupBy.
var (
	SqlSupportedGroupBy_name = map[int32]string{
		0: "SQL_GROUP_BY_UNRELATED",
		1: "SQL_GROUP_BY_BEYOND_SELECT",
	}
	SqlSupportedGroupBy_value = map[string]int32{
		"SQL_GROUP_BY_UNRELATED":     0,
		"SQL_GROUP_BY_BEYOND_SELECT": 1,
	}
)

func (x SqlSupportedGroupBy) Enum() *SqlSupportedGroupBy {
	p := new(SqlSupportedGroupBy)
	*p = x
	return p
}

func (x SqlSupportedGroupBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedGroupBy) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[7].Descriptor()
}

func (SqlSupportedGroupBy) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[7]
}

func (x SqlSupportedGroupBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedGroupBy.Descriptor instead.
func (SqlSupportedGroupBy) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{7}
}

type SqlSupportedElementActions int32

const (
	SqlSupportedElementActions_SQL_ELEMENT_IN_PROCEDURE_CALLS       SqlSupportedElementActions = 0
	SqlSupportedElementActions_SQL_ELEMENT_IN_INDEX_DEFINITIONS     SqlSupportedElementActions = 1
	SqlSupportedElementActions_SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS SqlSupportedElementActions = 2
)

// Enum value maps for SqlSupportedElementActions.
var (
	SqlSupportedElementActions_name = map[int32]string{
		0: "SQL_ELEMENT_IN_PROCEDURE_CALLS",
		1: "SQL_ELEMENT_IN_INDEX_DEFINITIONS",
		2: "SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS",
	}
	SqlSupportedElementActions_value = map[string]int32{
		"SQL_ELEMENT_IN_PROCEDURE_CALLS":       0,
		"SQL_ELEMENT_IN_INDEX_DEFINITIONS":     1,
		"SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS": 2,
	}
)

func (x SqlSupportedElementActions) Enum() *SqlSupportedElementActions {
	p := new(SqlSupportedElementActions)
	*p = x
	return p
}

func (x SqlSupportedElementActions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedElementActions) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[8].Descriptor()
}

func (SqlSupportedElementActions) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[8]
}

func (x SqlSupportedElementActions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedElementActions.Descriptor instead.
func (SqlSupportedElementActions) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{8}
}

type SqlSupportedPositionedCommands int32

const (
	SqlSupportedPositionedCommands_SQL_POSITIONED_DELETE SqlSupportedPositionedCommands = 0
	SqlSupportedPositionedCommands_SQL_POSITIONED_UPDATE SqlSupportedPositionedCommands = 1
)

// Enum value maps for SqlSupportedPositionedCommands.
var (
	SqlSupportedPositionedCommands_name = map[int32]string{
		0: "SQL_POSITIONED_DELETE",
		1: "SQL_POSITIONED_UPDATE",
	}
	SqlSupportedPositionedCommands_value = map[string]int32{
		"SQL_POSITIONED_DELETE": 0,
		"SQL_POSITIONED_UPDATE": 1,
	}
)

func (x SqlSupportedPositionedCommands) Enum() *SqlSupportedPositionedCommands {
	p := new(SqlSupportedPositionedCommands)
	*p = x
	return p
}

func (x SqlSupportedPositionedCommands) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedPositionedCommands) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[9].Descriptor()
}

func (SqlSupportedPositionedCommands) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[9]
}

func (x SqlSupportedPositionedCommands) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedPositionedCommands.Descriptor instead.
func (SqlSupportedPositionedCommands) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{9}
}

type SqlSupportedSubqueries int32

const (
	SqlSupportedSubqueries_SQL_SUBQUERIES_IN_COMPARISONS SqlSupportedSubqueries = 0
	SqlSupportedSubqueries_SQL_SUBQUERIES_IN_EXISTS      SqlSupportedSubqueries = 1
	SqlSupportedSubqueries_SQL_SUBQUERIES_IN_INS         SqlSupportedSubqueries = 2
	SqlSupportedSubqueries_SQL_SUBQUERIES_IN_QUANTIFIEDS SqlSupportedSubqueries = 3
)

// Enum value maps for SqlSupportedSubqueries.
var (
	SqlSupportedSubqueries_name = map[int32]string{
		0: "SQL_SUBQUERIES_IN_COMPARISONS",
		1: "SQL_SUBQUERIES_IN_EXISTS",
		2: "SQL_SUBQUERIES_IN_INS",
		3: "SQL_SUBQUERIES_IN_QUANTIFIEDS",
	}
	SqlSupportedSubqueries_value = map[string]int32{
		"SQL_SUBQUERIES_IN_COMPARISONS": 0,
		"SQL_SUBQUERIES_IN_EXISTS":      1,
		"SQL_SUBQUERIES_IN_INS":         2,
		"SQL_SUBQUERIES_IN_QUANTIFIEDS": 3,
	}
)

func (x SqlSupportedSubqueries) Enum() *SqlSupportedSubqueries {
	p := new(SqlSupportedSubqueries)
	*p = x
	return p
}

func (x SqlSupportedSubqueries) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedSubqueries) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[10].Descriptor()
}

func (SqlSupportedSubqueries) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[10]
}

func (x SqlSupportedSubqueries) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedSubqueries.Descriptor instead.
func (SqlSupportedSubqueries) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{10}
}

type SqlSupportedUnions int32

const (
	SqlSupportedUnions_SQL_UNION     SqlSupportedUnions = 0
	SqlSupportedUnions_SQL_UNION_ALL SqlSupportedUnions = 1
)

// Enum value maps for SqlSupportedUnions.
var (
	SqlSupportedUnions_name = map[int32]string{
		0: "SQL_UNION",
		1: "SQL_UNION_ALL",
	}
	SqlSupportedUnions_value = map[string]int32{
		"SQL_UNION":     0,
		"SQL_UNION_ALL": 1,
	}
)

func (x SqlSupportedUnions) Enum() *SqlSupportedUnions {
	p := new(SqlSupportedUnions)
	*p = x
	return p
}

func (x SqlSupportedUnions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedUnions) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[11].Descriptor()
}

func (SqlSupportedUnions) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[11]
}

func (x SqlSupportedUnions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedUnions.Descriptor instead.
func (SqlSupportedUnions) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{11}
}

type SqlTransactionIsolationLevel int32

const (
	SqlTransactionIsolationLevel_SQL_TRANSACTION_NONE             SqlTransactionIsolationLevel = 0
	SqlTransactionIsolationLevel_SQL_TRANSACTION_READ_UNCOMMITTED SqlTransactionIsolationLevel = 1
	SqlTransactionIsolationLevel_SQL_TRANSACTION_READ_COMMITTED   SqlTransactionIsolationLevel = 2
	SqlTransactionIsolationLevel_SQL_TRANSACTION_REPEATABLE_READ  SqlTransactionIsolationLevel = 3
	SqlTransactionIsolationLevel_SQL_TRANSACTION_SERIALIZABLE     SqlTransactionIsolationLevel = 4
)

// Enum value maps for SqlTransactionIsolationLevel.
var (
	SqlTransactionIsolationLevel_name = map[int32]string{
		0: "SQL_TRANSACTION_NONE",
		1: "SQL_TRANSACTION_READ_UNCOMMITTED",
		2: "SQL_TRANSACTION_READ_COMMITTED",
		3: "SQL_TRANSACTION_REPEATABLE_READ",
		4: "SQL_TRANSACTION_SERIALIZABLE",
	}
	SqlTransactionIsolationLevel_value = map[string]int32{
		"SQL_TRANSACTION_NONE":             0,
		"SQL_TRANSACTION_READ_UNCOMMITTED": 1,
		"SQL_TRANSACTION_READ_COMMITTED":   2,
		"SQL_TRANSACTION_REPEATABLE_READ":  3,
		"SQL_TRANSACTION_SERIALIZABLE":     4,
	}
)

func (x SqlTransactionIsolationLevel) Enum() *SqlTransactionIsolationLevel {
	p := new(SqlTransactionIsolationLevel)
	*p = x
	return p
}

func (x SqlTransactionIsolationLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlTransactionIsolationLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[12].Descriptor()
}

func (SqlTransactionIsolationLevel) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[12]
}

func (x SqlTransactionIsolationLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlTransactionIsolationLevel.Descriptor instead.
func (SqlTransactionIsolationLevel) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{12}
}

type SqlSupportedTransactions int32

const (
	SqlSupportedTransactions_SQL_TRANSACTION_UNSPECIFIED        SqlSupportedTransactions = 0
	SqlSupportedTransactions_SQL_DATA_DEFINITION_TRANSACTIONS   SqlSupportedTransactions = 1
	SqlSupportedTransactions_SQL_DATA_MANIPULATION_TRANSACTIONS SqlSupportedTransactions = 2
)

// Enum value maps for SqlSupportedTransactions.
var (
	SqlSupportedTransactions_name = map[int32]string{
		0: "SQL_TRANSACTION_UNSPECIFIED",
		1: "SQL_DATA_DEFINITION_TRANSACTIONS",
		2: "SQL_DATA_MANIPULATION_TRANSACTIONS",
	}
	SqlSupportedTransactions_value = map[string]int32{
		"SQL_TRANSACTION_UNSPECIFIED":        0,
		"SQL_DATA_DEFINITION_TRANSACTIONS":   1,
		"SQL_DATA_MANIPULATION_TRANSACTIONS": 2,
	}
)

func (x SqlSupportedTransactions) Enum() *SqlSupportedTransactions {
	p := new(SqlSupportedTransactions)
	*p = x
	return p
}

func (x SqlSupportedTransactions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedTransactions) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[13].Descriptor()
}

func (SqlSupportedTransactions) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[13]
}

func (x SqlSupportedTransactions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedTransactions.Descriptor instead.
func (SqlSupportedTransactions) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{13}
}

type SqlSupportedResultSetType int32

const (
	SqlSupportedResultSetType_SQL_RESULT_SET_TYPE_UNSPECIFIED        SqlSupportedResultSetType = 0
	SqlSupportedResultSetType_SQL_RESULT_SET_TYPE_FORWARD_ONLY       SqlSupportedResultSetType = 1
	SqlSupportedResultSetType_SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE SqlSupportedResultSetType = 2
	SqlSupportedResultSetType_SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE   SqlSupportedResultSetType = 3
)

// Enum value maps for SqlSupportedResultSetType.
var (
	SqlSupportedResultSetType_name = map[int32]string{
		0: "SQL_RESULT_SET_TYPE_UNSPECIFIED",
		1: "SQL_RESULT_SET_TYPE_FORWARD_ONLY",
		2: "SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE",
		3: "SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE",
	}
	SqlSupportedResultSetType_value = map[string]int32{
		"SQL_RESULT_SET_TYPE_UNSPECIFIED":        0,
		"SQL_RESULT_SET_TYPE_FORWARD_ONLY":       1,
		"SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE": 2,
		"SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE":   3,
	}
)

func (x SqlSupportedResultSetType) Enum() *SqlSupportedResultSetType {
	p := new(SqlSupportedResultSetType)
	*p = x
	return p
}

func (x SqlSupportedResultSetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedResultSetType) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[14].Descriptor()
}

func (SqlSupportedResultSetType) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[14]
}

func (x SqlSupportedResultSetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedResultSetType.Descriptor instead.
func (SqlSupportedResultSetType) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{14}
}

type SqlSupportedResultSetConcurrency int32

const (
	SqlSupportedResultSetConcurrency_SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED SqlSupportedResultSetConcurrency = 0
	SqlSupportedResultSetConcurrency_SQL_RESULT_SET_CONCURRENCY_READ_ONLY   SqlSupportedResultSetConcurrency = 1
	SqlSupportedResultSetConcurrency_SQL_RESULT_SET_CONCURRENCY_UPDATABLE   SqlSupportedResultSetConcurrency = 2
)

// Enum value maps for SqlSupportedResultSetConcurrency.
var (
	SqlSupportedResultSetConcurrency_name = map[int32]string{
		0: "SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED",
		1: "SQL_RESULT_SET_CONCURRENCY_READ_ONLY",
		2: "SQL_RESULT_SET_CONCURRENCY_UPDATABLE",
	}
	SqlSupportedResultSetConcurrency_value = map[string]int32{
		"SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED": 0,
		"SQL_RESULT_SET_CONCURRENCY_READ_ONLY":   1,
		"SQL_RESULT_SET_CONCURRENCY_UPDATABLE":   2,
	}
)

func (x SqlSupportedResultSetConcurrency) Enum() *SqlSupportedResultSetConcurrency {
	p := new(SqlSupportedResultSetConcurrency)
	*p = x
	return p
}

func (x SqlSupportedResultSetConcurrency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportedResultSetConcurrency) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[15].Descriptor()
}

func (SqlSupportedResultSetConcurrency) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[15]
}

func (x SqlSupportedResultSetConcurrency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportedResultSetConcurrency.Descriptor instead.
func (SqlSupportedResultSetConcurrency) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{15}
}

type SqlSupportsConvert int32

const (
	SqlSupportsConvert_SQL_CONVERT_BIGINT              SqlSupportsConvert = 0
	SqlSupportsConvert_SQL_CONVERT_BINARY              SqlSupportsConvert = 1
	SqlSupportsConvert_SQL_CONVERT_BIT                 SqlSupportsConvert = 2
	SqlSupportsConvert_SQL_CONVERT_CHAR                SqlSupportsConvert = 3
	SqlSupportsConvert_SQL_CONVERT_DATE                SqlSupportsConvert = 4
	SqlSupportsConvert_SQL_CONVERT_DECIMAL             SqlSupportsConvert = 5
	SqlSupportsConvert_SQL_CONVERT_FLOAT               SqlSupportsConvert = 6
	SqlSupportsConvert_SQL_CONVERT_INTEGER             SqlSupportsConvert = 7
	SqlSupportsConvert_SQL_CONVERT_INTERVAL_DAY_TIME   SqlSupportsConvert = 8
	SqlSupportsConvert_SQL_CONVERT_INTERVAL_YEAR_MONTH SqlSupportsConvert = 9
	SqlSupportsConvert_SQL_CONVERT_LONGVARBINARY       SqlSupportsConvert = 10
	SqlSupportsConvert_SQL_CONVERT_LONGVARCHAR         SqlSupportsConvert = 11
	SqlSupportsConvert_SQL_CONVERT_NUMERIC             SqlSupportsConvert = 12
	SqlSupportsConvert_SQL_CONVERT_REAL                SqlSupportsConvert = 13
	SqlSupportsConvert_SQL_CONVERT_SMALLINT            SqlSupportsConvert = 14
	SqlSupportsConvert_SQL_CONVERT_TIME                SqlSupportsConvert = 15
	SqlSupportsConvert_SQL_CONVERT_TIMESTAMP           SqlSupportsConvert = 16
	SqlSupportsConvert_SQL_CONVERT_TINYINT             SqlSupportsConvert = 17
	SqlSupportsConvert_SQL_CONVERT_VARBINARY           SqlSupportsConvert = 18
	SqlSupportsConvert_SQL_CONVERT_VARCHAR             SqlSupportsConvert = 19
)

// Enum value maps for SqlSupportsConvert.
var (
	SqlSupportsConvert_name = map[int32]string{
		0:  "SQL_CONVERT_BIGINT",
		1:  "SQL_CONVERT_BINARY",
		2:  "SQL_CONVERT_BIT",
		3:  "SQL_CONVERT_CHAR",
		4:  "SQL_CONVERT_DATE",
		5:  "SQL_CONVERT_DECIMAL",
		6:  "SQL_CONVERT_FLOAT",
		7:  "SQL_CONVERT_INTEGER",
		8:  "SQL_CONVERT_INTERVAL_DAY_TIME",
		9:  "SQL_CONVERT_INTERVAL_YEAR_MONTH",
		10: "SQL_CONVERT_LONGVARBINARY",
		11: "SQL_CONVERT_LONGVARCHAR",
		12: "SQL_CONVERT_NUMERIC",
		13: "SQL_CONVERT_REAL",
		14: "SQL_CONVERT_SMALLINT",
		15: "SQL_CONVERT_TIME",
		16: "SQL_CONVERT_TIMESTAMP",
		17: "SQL_CONVERT_TINYINT",
		18: "SQL_CONVERT_VARBINARY",
		19: "SQL_CONVERT_VARCHAR",
	}
	SqlSupportsConvert_value = map[string]int32{
		"SQL_CONVERT_BIGINT":              0,
		"SQL_CONVERT_BINARY":              1,
		"SQL_CONVERT_BIT":                 2,
		"SQL_CONVERT_CHAR":                3,
		"SQL_CONVERT_DATE":                4,
		"SQL_CONVERT_DECIMAL":             5,
		"SQL_CONVERT_FLOAT":               6,
		"SQL_CONVERT_INTEGER":             7,
		"SQL_CONVERT_INTERVAL_DAY_TIME":   8,
		"SQL_CONVERT_INTERVAL_YEAR_MONTH": 9,
		"SQL_CONVERT_LONGVARBINARY":       10,
		"SQL_CONVERT_LONGVARCHAR":         11,
		"SQL_CONVERT_NUMERIC":             12,
		"SQL_CONVERT_REAL":                13,
		"SQL_CONVERT_SMALLINT":            14,
		"SQL_CONVERT_TIME":                15,
		"SQL_CONVERT_TIMESTAMP":           16,
		"SQL_CONVERT_TINYINT":             17,
		"SQL_CONVERT_VARBINARY":           18,
		"SQL_CONVERT_VARCHAR":             19,
	}
)

func (x SqlSupportsConvert) Enum() *SqlSupportsConvert {
	p := new(SqlSupportsConvert)
	*p = x
	return p
}

func (x SqlSupportsConvert) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSupportsConvert) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[16].Descriptor()
}

func (SqlSupportsConvert) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[16]
}

func (x SqlSupportsConvert) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSupportsConvert.Descriptor instead.
func (SqlSupportsConvert) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{16}
}

//*
// The JDBC/ODBC-defined type of any object.
// All the values here are the same as in the JDBC and ODBC specs.
type XdbcDataType int32

const (
	XdbcDataType_XDBC_UNKNOWN_TYPE  XdbcDataType = 0
	XdbcDataType_XDBC_CHAR          XdbcDataType = 1
	XdbcDataType_XDBC_NUMERIC       XdbcDataType = 2
	XdbcDataType_XDBC_DECIMAL       XdbcDataType = 3
	XdbcDataType_XDBC_INTEGER       XdbcDataType = 4
	XdbcDataType_XDBC_SMALLINT      XdbcDataType = 5
	XdbcDataType_XDBC_FLOAT         XdbcDataType = 6
	XdbcDataType_XDBC_REAL          XdbcDataType = 7
	XdbcDataType_XDBC_DOUBLE        XdbcDataType = 8
	XdbcDataType_XDBC_DATETIME      XdbcDataType = 9
	XdbcDataType_XDBC_INTERVAL      XdbcDataType = 10
	XdbcDataType_XDBC_VARCHAR       XdbcDataType = 12
	XdbcDataType_XDBC_DATE          XdbcDataType = 91
	XdbcDataType_XDBC_TIME          XdbcDataType = 92
	XdbcDataType_XDBC_TIMESTAMP     XdbcDataType = 93
	XdbcDataType_XDBC_LONGVARCHAR   XdbcDataType = -1
	XdbcDataType_XDBC_BINARY        XdbcDataType = -2
	XdbcDataType_XDBC_VARBINARY     XdbcDataType = -3
	XdbcDataType_XDBC_LONGVARBINARY XdbcDataType = -4
	XdbcDataType_XDBC_BIGINT        XdbcDataType = -5
	XdbcDataType_XDBC_TINYINT       XdbcDataType = -6
	XdbcDataType_XDBC_BIT           XdbcDataType = -7
	XdbcDataType_XDBC_WCHAR         XdbcDataType = -8
	XdbcDataType_XDBC_WVARCHAR      XdbcDataType = -9
)

// Enum value maps for XdbcDataType.
var (
	XdbcDataType_name = map[int32]string{
		0:  "XDBC_UNKNOWN_TYPE",
		1:  "XDBC_CHAR",
		2:  "XDBC_NUMERIC",
		3:  "XDBC_DECIMAL",
		4:  "XDBC_INTEGER",
		5:  "XDBC_SMALLINT",
		6:  "XDBC_FLOAT",
		7:  "XDBC_REAL",
		8:  "XDBC_DOUBLE",
		9:  "XDBC_DATETIME",
		10: "XDBC_INTERVAL",
		12: "XDBC_VARCHAR",
		91: "XDBC_DATE",
		92: "XDBC_TIME",
		93: "XDBC_TIMESTAMP",
		-1: "XDBC_LONGVARCHAR",
		-2: "XDBC_BINARY",
		-3: "XDBC_VARBINARY",
		-4: "XDBC_LONGVARBINARY",
		-5: "XDBC_BIGINT",
		-6: "XDBC_TINYINT",
		-7: "XDBC_BIT",
		-8: "XDBC_WCHAR",
		-9: "XDBC_WVARCHAR",
	}
	XdbcDataType_value = map[string]int32{
		"XDBC_UNKNOWN_TYPE":  0,
		"XDBC_CHAR":          1,
		"XDBC_NUMERIC":       2,
		"XDBC_DECIMAL":       3,
		"XDBC_INTEGER":       4,
		"XDBC_SMALLINT":      5,
		"XDBC_FLOAT":         6,
		"XDBC_REAL":          7,
		"XDBC_DOUBLE":        8,
		"XDBC_DATETIME":      9,
		"XDBC_INTERVAL":      10,
		"XDBC_VARCHAR":       12,
		"XDBC_DATE":          91,
		"XDBC_TIME":          92,
		"XDBC_TIMESTAMP":     93,
		"XDBC_LONGVARCHAR":   -1,
		"XDBC_BINARY":        -2,
		"XDBC_VARBINARY":     -3,
		"XDBC_LONGVARBINARY": -4,
		"XDBC_BIGINT":        -5,
		"XDBC_TINYINT":       -6,
		"XDBC_BIT":           -7,
		"XDBC_WCHAR":         -8,
		"XDBC_WVARCHAR":      -9,
	}
)

func (x XdbcDataType) Enum() *XdbcDataType {
	p := new(XdbcDataType)
	*p = x
	return p
}

func (x XdbcDataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (XdbcDataType) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[17].Descriptor()
}

func (XdbcDataType) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[17]
}

func (x XdbcDataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use XdbcDataType.Descriptor instead.
func (XdbcDataType) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{17}
}

//*
// Detailed subtype information for XDBC_TYPE_DATETIME and XDBC_TYPE_INTERVAL.
type XdbcDatetimeSubcode int32

const (
	XdbcDatetimeSubcode_XDBC_SUBCODE_UNKNOWN                   XdbcDatetimeSubcode = 0
	XdbcDatetimeSubcode_XDBC_SUBCODE_YEAR                      XdbcDatetimeSubcode = 1
	XdbcDatetimeSubcode_XDBC_SUBCODE_DATE                      XdbcDatetimeSubcode = 1
	XdbcDatetimeSubcode_XDBC_SUBCODE_TIME                      XdbcDatetimeSubcode = 2
	XdbcDatetimeSubcode_XDBC_SUBCODE_MONTH                     XdbcDatetimeSubcode = 2
	XdbcDatetimeSubcode_XDBC_SUBCODE_TIMESTAMP                 XdbcDatetimeSubcode = 3
	XdbcDatetimeSubcode_XDBC_SUBCODE_DAY                       XdbcDatetimeSubcode = 3
	XdbcDatetimeSubcode_XDBC_SUBCODE_TIME_WITH_TIMEZONE        XdbcDatetimeSubcode = 4
	XdbcDatetimeSubcode_XDBC_SUBCODE_HOUR                      XdbcDatetimeSubcode = 4
	XdbcDatetimeSubcode_XDBC_SUBCODE_TIMESTAMP_WITH_TIMEZONE   XdbcDatetimeSubcode = 5
	XdbcDatetimeSubcode_XDBC_SUBCODE_MINUTE                    XdbcDatetimeSubcode = 5
	XdbcDatetimeSubcode_XDBC_SUBCODE_SECOND                    XdbcDatetimeSubcode = 6
	XdbcDatetimeSubcode_XDBC_SUBCODE_YEAR_TO_MONTH             XdbcDatetimeSubcode = 7
	XdbcDatetimeSubcode_XDBC_SUBCODE_DAY_TO_HOUR               XdbcDatetimeSubcode = 8
	XdbcDatetimeSubcode_XDBC_SUBCODE_DAY_TO_MINUTE             XdbcDatetimeSubcode = 9
	XdbcDatetimeSubcode_XDBC_SUBCODE_DAY_TO_SECOND             XdbcDatetimeSubcode = 10
	XdbcDatetimeSubcode_XDBC_SUBCODE_HOUR_TO_MINUTE            XdbcDatetimeSubcode = 11
	XdbcDatetimeSubcode_XDBC_SUBCODE_HOUR_TO_SECOND            XdbcDatetimeSubcode = 12
	XdbcDatetimeSubcode_XDBC_SUBCODE_MINUTE_TO_SECOND          XdbcDatetimeSubcode = 13
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_YEAR             XdbcDatetimeSubcode = 101
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_MONTH            XdbcDatetimeSubcode = 102
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_DAY              XdbcDatetimeSubcode = 103
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_HOUR             XdbcDatetimeSubcode = 104
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_MINUTE           XdbcDatetimeSubcode = 105
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_SECOND           XdbcDatetimeSubcode = 106
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_YEAR_TO_MONTH    XdbcDatetimeSubcode = 107
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_DAY_TO_HOUR      XdbcDatetimeSubcode = 108
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_DAY_TO_MINUTE    XdbcDatetimeSubcode = 109
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_DAY_TO_SECOND    XdbcDatetimeSubcode = 110
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_HOUR_TO_MINUTE   XdbcDatetimeSubcode = 111
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_HOUR_TO_SECOND   XdbcDatetimeSubcode = 112
	XdbcDatetimeSubcode_XDBC_SUBCODE_INTERVAL_MINUTE_TO_SECOND XdbcDatetimeSubcode = 113
)

// Enum value maps for XdbcDatetimeSubcode.
var (
	XdbcDatetimeSubcode_name = map[int32]string{
		0: "XDBC_SUBCODE_UNKNOWN",
		1: "XDBC_SUBCODE_YEAR",
		// Duplicate value: 1: "XDBC_SUBCODE_DATE",
		2: "XDBC_SUBCODE_TIME",
		// Duplicate value: 2: "XDBC_SUBCODE_MONTH",
		3: "XDBC_SUBCODE_TIMESTAMP",
		// Duplicate value: 3: "XDBC_SUBCODE_DAY",
		4: "XDBC_SUBCODE_TIME_WITH_TIMEZONE",
		// Duplicate value: 4: "XDBC_SUBCODE_HOUR",
		5: "XDBC_SUBCODE_TIMESTAMP_WITH_TIMEZONE",
		// Duplicate value: 5: "XDBC_SUBCODE_MINUTE",
		6:   "XDBC_SUBCODE_SECOND",
		7:   "XDBC_SUBCODE_YEAR_TO_MONTH",
		8:   "XDBC_SUBCODE_DAY_TO_HOUR",
		9:   "XDBC_SUBCODE_DAY_TO_MINUTE",
		10:  "XDBC_SUBCODE_DAY_TO_SECOND",
		11:  "XDBC_SUBCODE_HOUR_TO_MINUTE",
		12:  "XDBC_SUBCODE_HOUR_TO_SECOND",
		13:  "XDBC_SUBCODE_MINUTE_TO_SECOND",
		101: "XDBC_SUBCODE_INTERVAL_YEAR",
		102: "XDBC_SUBCODE_INTERVAL_MONTH",
		103: "XDBC_SUBCODE_INTERVAL_DAY",
		104: "XDBC_SUBCODE_INTERVAL_HOUR",
		105: "XDBC_SUBCODE_INTERVAL_MINUTE",
		106: "XDBC_SUBCODE_INTERVAL_SECOND",
		107: "XDBC_SUBCODE_INTERVAL_YEAR_TO_MONTH",
		108: "XDBC_SUBCODE_INTERVAL_DAY_TO_HOUR",
		109: "XDBC_SUBCODE_INTERVAL_DAY_TO_MINUTE",
		110: "XDBC_SUBCODE_INTERVAL_DAY_TO_SECOND",
		111: "XDBC_SUBCODE_INTERVAL_HOUR_TO_MINUTE",
		112: "XDBC_SUBCODE_INTERVAL_HOUR_TO_SECOND",
		113: "XDBC_SUBCODE_INTERVAL_MINUTE_TO_SECOND",
	}
	XdbcDatetimeSubcode_value = map[string]int32{
		"XDBC_SUBCODE_UNKNOWN":                   0,
		"XDBC_SUBCODE_YEAR":                      1,
		"XDBC_SUBCODE_DATE":                      1,
		"XDBC_SUBCODE_TIME":                      2,
		"XDBC_SUBCODE_MONTH":                     2,
		"XDBC_SUBCODE_TIMESTAMP":                 3,
		"XDBC_SUBCODE_DAY":                       3,
		"XDBC_SUBCODE_TIME_WITH_TIMEZONE":        4,
		"XDBC_SUBCODE_HOUR":                      4,
		"XDBC_SUBCODE_TIMESTAMP_WITH_TIMEZONE":   5,
		"XDBC_SUBCODE_MINUTE":                    5,
		"XDBC_SUBCODE_SECOND":                    6,
		"XDBC_SUBCODE_YEAR_TO_MONTH":             7,
		"XDBC_SUBCODE_DAY_TO_HOUR":               8,
		"XDBC_SUBCODE_DAY_TO_MINUTE":             9,
		"XDBC_SUBCODE_DAY_TO_SECOND":             10,
		"XDBC_SUBCODE_HOUR_TO_MINUTE":            11,
		"XDBC_SUBCODE_HOUR_TO_SECOND":            12,
		"XDBC_SUBCODE_MINUTE_TO_SECOND":          13,
		"XDBC_SUBCODE_INTERVAL_YEAR":             101,
		"XDBC_SUBCODE_INTERVAL_MONTH":            102,
		"XDBC_SUBCODE_INTERVAL_DAY":              103,
		"XDBC_SUBCODE_INTERVAL_HOUR":             104,
		"XDBC_SUBCODE_INTERVAL_MINUTE":           105,
		"XDBC_SUBCODE_INTERVAL_SECOND":           106,
		"XDBC_SUBCODE_INTERVAL_YEAR_TO_MONTH":    107,
		"XDBC_SUBCODE_INTERVAL_DAY_TO_HOUR":      108,
		"XDBC_SUBCODE_INTERVAL_DAY_TO_MINUTE":    109,
		"XDBC_SUBCODE_INTERVAL_DAY_TO_SECOND":    110,
		"XDBC_SUBCODE_INTERVAL_HOUR_TO_MINUTE":   111,
		"XDBC_SUBCODE_INTERVAL_HOUR_TO_SECOND":   112,
		"XDBC_SUBCODE_INTERVAL_MINUTE_TO_SECOND": 113,
	}
)

func (x XdbcDatetimeSubcode) Enum() *XdbcDatetimeSubcode {
	p := new(XdbcDatetimeSubcode)
	*p = x
	return p
}

func (x XdbcDatetimeSubcode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (XdbcDatetimeSubcode) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[18].Descriptor()
}

func (XdbcDatetimeSubcode) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[18]
}

func (x XdbcDatetimeSubcode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use XdbcDatetimeSubcode.Descriptor instead.
func (XdbcDatetimeSubcode) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{18}
}

type Nullable int32

const (
	//*
	// Indicates that the fields does not allow the use of null values.
	Nullable_NULLABILITY_NO_NULLS Nullable = 0
	//*
	// Indicates that the fields allow the use of null values.
	Nullable_NULLABILITY_NULLABLE Nullable = 1
	//*
	// Indicates that nullability of the fields cannot be determined.
	Nullable_NULLABILITY_UNKNOWN Nullable = 2
)

// Enum value maps for Nullable.
var (
	Nullable_name = map[int32]string{
		0: "NULLABILITY_NO_NULLS",
		1: "NULLABILITY_NULLABLE",
		2: "NULLABILITY_UNKNOWN",
	}
	Nullable_value = map[string]int32{
		"NULLABILITY_NO_NULLS": 0,
		"NULLABILITY_NULLABLE": 1,
		"NULLABILITY_UNKNOWN":  2,
	}
)

func (x Nullable) Enum() *Nullable {
	p := new(Nullable)
	*p = x
	return p
}

func (x Nullable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Nullable) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[19].Descriptor()
}

func (Nullable) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[19]
}

func (x Nullable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Nullable.Descriptor instead.
func (Nullable) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{19}
}

type Searchable int32

const (
	//*
	// Indicates that column cannot be used in a WHERE clause.
	Searchable_SEARCHABLE_NONE Searchable = 0
	//*
	// Indicates that the column can be used in a WHERE clause if it is using a
	// LIKE operator.
	Searchable_SEARCHABLE_CHAR Searchable = 1
	//*
	// Indicates that the column can be used In a WHERE clause with any
	// operator other than LIKE.
	//
	// - Allowed operators: comparison, quantified comparison, BETWEEN,
	//                      DISTINCT, IN, MATCH, and UNIQUE.
	Searchable_SEARCHABLE_BASIC Searchable = 2
	//*
	// Indicates that the column can be used in a WHERE clause using any operator.
	Searchable_SEARCHABLE_FULL Searchable = 3
)

// Enum value maps for Searchable.
var (
	Searchable_name = map[int32]string{
		0: "SEARCHABLE_NONE",
		1: "SEARCHABLE_CHAR",
		2: "SEARCHABLE_BASIC",
		3: "SEARCHABLE_FULL",
	}
	Searchable_value = map[string]int32{
		"SEARCHABLE_NONE":  0,
		"SEARCHABLE_CHAR":  1,
		"SEARCHABLE_BASIC": 2,
		"SEARCHABLE_FULL":  3,
	}
)

func (x Searchable) Enum() *Searchable {
	p := new(Searchable)
	*p = x
	return p
}

func (x Searchable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Searchable) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[20].Descriptor()
}

func (Searchable) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[20]
}

func (x Searchable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Searchable.Descriptor instead.
func (Searchable) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{20}
}

type UpdateDeleteRules int32

const (
	UpdateDeleteRules_CASCADE     UpdateDeleteRules = 0
	UpdateDeleteRules_RESTRICT    UpdateDeleteRules = 1
	UpdateDeleteRules_SET_NULL    UpdateDeleteRules = 2
	UpdateDeleteRules_NO_ACTION   UpdateDeleteRules = 3
	UpdateDeleteRules_SET_DEFAULT UpdateDeleteRules = 4
)

// Enum value maps for UpdateDeleteRules.
var (
	UpdateDeleteRules_name = map[int32]string{
		0: "CASCADE",
		1: "RESTRICT",
		2: "SET_NULL",
		3: "NO_ACTION",
		4: "SET_DEFAULT",
	}
	UpdateDeleteRules_value = map[string]int32{
		"CASCADE":     0,
		"RESTRICT":    1,
		"SET_NULL":    2,
		"NO_ACTION":   3,
		"SET_DEFAULT": 4,
	}
)

func (x UpdateDeleteRules) Enum() *UpdateDeleteRules {
	p := new(UpdateDeleteRules)
	*p = x
	return p
}

func (x UpdateDeleteRules) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateDeleteRules) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[21].Descriptor()
}

func (UpdateDeleteRules) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[21]
}

func (x UpdateDeleteRules) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateDeleteRules.Descriptor instead.
func (UpdateDeleteRules) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{21}
}

type ActionEndTransactionRequest_EndTransaction int32

const (
	ActionEndTransactionRequest_END_TRANSACTION_UNSPECIFIED ActionEndTransactionRequest_EndTransaction = 0
	// Commit the transaction.
	ActionEndTransactionRequest_END_TRANSACTION_COMMIT ActionEndTransactionRequest_EndTransaction = 1
	// Roll back the transaction.
	ActionEndTransactionRequest_END_TRANSACTION_ROLLBACK ActionEndTransactionRequest_EndTransaction = 2
)

// Enum value maps for ActionEndTransactionRequest_EndTransaction.
var (
	ActionEndTransactionRequest_EndTransaction_name = map[int32]string{
		0: "END_TRANSACTION_UNSPECIFIED",
		1: "END_TRANSACTION_COMMIT",
		2: "END_TRANSACTION_ROLLBACK",
	}
	ActionEndTransactionRequest_EndTransaction_value = map[string]int32{
		"END_TRANSACTION_UNSPECIFIED": 0,
		"END_TRANSACTION_COMMIT":      1,
		"END_TRANSACTION_ROLLBACK":    2,
	}
)

func (x ActionEndTransactionRequest_EndTransaction) Enum() *ActionEndTransactionRequest_EndTransaction {
	p := new(ActionEndTransactionRequest_EndTransaction)
	*p = x
	return p
}

func (x ActionEndTransactionRequest_EndTransaction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionEndTransactionRequest_EndTransaction) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[22].Descriptor()
}

func (ActionEndTransactionRequest_EndTransaction) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[22]
}

func (x ActionEndTransactionRequest_EndTransaction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionEndTransactionRequest_EndTransaction.Descriptor instead.
func (ActionEndTransactionRequest_EndTransaction) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{19, 0}
}

type ActionEndSavepointRequest_EndSavepoint int32

const (
	ActionEndSavepointRequest_END_SAVEPOINT_UNSPECIFIED ActionEndSavepointRequest_EndSavepoint = 0
	// Release the savepoint.
	ActionEndSavepointRequest_END_SAVEPOINT_RELEASE ActionEndSavepointRequest_EndSavepoint = 1
	// Roll back to a savepoint.
	ActionEndSavepointRequest_END_SAVEPOINT_ROLLBACK ActionEndSavepointRequest_EndSavepoint = 2
)

// Enum value maps for ActionEndSavepointRequest_EndSavepoint.
var (
	ActionEndSavepointRequest_EndSavepoint_name = map[int32]string{
		0: "END_SAVEPOINT_UNSPECIFIED",
		1: "END_SAVEPOINT_RELEASE",
		2: "END_SAVEPOINT_ROLLBACK",
	}
	ActionEndSavepointRequest_EndSavepoint_value = map[string]int32{
		"END_SAVEPOINT_UNSPECIFIED": 0,
		"END_SAVEPOINT_RELEASE":     1,
		"END_SAVEPOINT_ROLLBACK":    2,
	}
)

func (x ActionEndSavepointRequest_EndSavepoint) Enum() *ActionEndSavepointRequest_EndSavepoint {
	p := new(ActionEndSavepointRequest_EndSavepoint)
	*p = x
	return p
}

func (x ActionEndSavepointRequest_EndSavepoint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionEndSavepointRequest_EndSavepoint) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[23].Descriptor()
}

func (ActionEndSavepointRequest_EndSavepoint) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[23]
}

func (x ActionEndSavepointRequest_EndSavepoint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionEndSavepointRequest_EndSavepoint.Descriptor instead.
func (ActionEndSavepointRequest_EndSavepoint) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{20, 0}
}

type ActionCancelQueryResult_CancelResult int32

const (
	// The cancellation status is unknown. Servers should avoid using
	// this value (send a NOT_FOUND error if the requested query is
	// not known). Clients can retry the request.
	ActionCancelQueryResult_CANCEL_RESULT_UNSPECIFIED ActionCancelQueryResult_CancelResult = 0
	// The cancellation request is complete. Subsequent requests with
	// the same payload may return CANCELLED or a NOT_FOUND error.
	ActionCancelQueryResult_CANCEL_RESULT_CANCELLED ActionCancelQueryResult_CancelResult = 1
	// The cancellation request is in progress. The client may retry
	// the cancellation request.
	ActionCancelQueryResult_CANCEL_RESULT_CANCELLING ActionCancelQueryResult_CancelResult = 2
	// The query is not cancellable. The client should not retry the
	// cancellation request.
	ActionCancelQueryResult_CANCEL_RESULT_NOT_CANCELLABLE ActionCancelQueryResult_CancelResult = 3
)

// Enum value maps for ActionCancelQueryResult_CancelResult.
var (
	ActionCancelQueryResult_CancelResult_name = map[int32]string{
		0: "CANCEL_RESULT_UNSPECIFIED",
		1: "CANCEL_RESULT_CANCELLED",
		2: "CANCEL_RESULT_CANCELLING",
		3: "CANCEL_RESULT_NOT_CANCELLABLE",
	}
	ActionCancelQueryResult_CancelResult_value = map[string]int32{
		"CANCEL_RESULT_UNSPECIFIED":     0,
		"CANCEL_RESULT_CANCELLED":       1,
		"CANCEL_RESULT_CANCELLING":      2,
		"CANCEL_RESULT_NOT_CANCELLABLE": 3,
	}
)

func (x ActionCancelQueryResult_CancelResult) Enum() *ActionCancelQueryResult_CancelResult {
	p := new(ActionCancelQueryResult_CancelResult)
	*p = x
	return p
}

func (x ActionCancelQueryResult_CancelResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionCancelQueryResult_CancelResult) Descriptor() protoreflect.EnumDescriptor {
	return file_FlightSql_proto_enumTypes[24].Descriptor()
}

func (ActionCancelQueryResult_CancelResult) Type() protoreflect.EnumType {
	return &file_FlightSql_proto_enumTypes[24]
}

func (x ActionCancelQueryResult_CancelResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionCancelQueryResult_CancelResult.Descriptor instead.
func (ActionCancelQueryResult_CancelResult) EnumDescriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{29, 0}
}

//
// Represents a metadata request. Used in the command member of FlightDescriptor
// for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the metadata request.
//
// The returned Arrow schema will be:
// <
//  info_name: uint32 not null,
//  value: dense_union<
//              string_value: utf8,
//              bool_value: bool,
//              bigint_value: int64,
//              int32_bitmask: int32,
//              string_list: list<string_data: utf8>
//              int32_to_int32_list_map: map<key: int32, value: list<$data$: int32>>
// >
// where there is one row per requested piece of metadata information.
type CommandGetSqlInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Values are modelled after ODBC's SQLGetInfo() function. This information is intended to provide
	// Flight SQL clients with basic, SQL syntax and SQL functions related information.
	// More information types can be added in future releases.
	// E.g. more SQL syntax support types, scalar functions support, type conversion support etc.
	//
	// Note that the set of metadata may expand.
	//
	// Initially, Flight SQL will support the following information types:
	// - Server Information - Range [0-500)
	// - Syntax Information - Range [500-1000)
	// Range [0-10,000) is reserved for defaults (see SqlInfo enum for default options).
	// Custom options should start at 10,000.
	//
	// If omitted, then all metadata will be retrieved.
	// Flight SQL Servers may choose to include additional metadata above and beyond the specified set, however they must
	// at least return the specified set. IDs ranging from 0 to 10,000 (exclusive) are reserved for future use.
	// If additional metadata is included, the metadata IDs should start from 10,000.
	Info []uint32 `protobuf:"varint,1,rep,packed,name=info,proto3" json:"info,omitempty"`
}

func (x *CommandGetSqlInfo) Reset() {
	*x = CommandGetSqlInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetSqlInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetSqlInfo) ProtoMessage() {}

func (x *CommandGetSqlInfo) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetSqlInfo.ProtoReflect.Descriptor instead.
func (*CommandGetSqlInfo) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{0}
}

func (x *CommandGetSqlInfo) GetInfo() []uint32 {
	if x != nil {
		return x.Info
	}
	return nil
}

//
// Represents a request to retrieve information about data type supported on a Flight SQL enabled backend.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned schema will be:
// <
//   type_name: utf8 not null (The name of the data type, for example: VARCHAR, INTEGER, etc),
//   data_type: int32 not null (The SQL data type),
//   column_size: int32 (The maximum size supported by that column.
//                       In case of exact numeric types, this represents the maximum precision.
//                       In case of string types, this represents the character length.
//                       In case of datetime data types, this represents the length in characters of the string representation.
//                       NULL is returned for data types where column size is not applicable.),
//   literal_prefix: utf8 (Character or characters used to prefix a literal, NULL is returned for
//                         data types where a literal prefix is not applicable.),
//   literal_suffix: utf8 (Character or characters used to terminate a literal,
//                         NULL is returned for data types where a literal suffix is not applicable.),
//   create_params: list<utf8 not null>
//                        (A list of keywords corresponding to which parameters can be used when creating
//                         a column for that specific type.
//                         NULL is returned if there are no parameters for the data type definition.),
//   nullable: int32 not null (Shows if the data type accepts a NULL value. The possible values can be seen in the
//                             Nullable enum.),
//   case_sensitive: bool not null (Shows if a character data type is case-sensitive in collations and comparisons),
//   searchable: int32 not null (Shows how the data type is used in a WHERE clause. The possible values can be seen in the
//                               Searchable enum.),
//   unsigned_attribute: bool (Shows if the data type is unsigned. NULL is returned if the attribute is
//                             not applicable to the data type or the data type is not numeric.),
//   fixed_prec_scale: bool not null (Shows if the data type has predefined fixed precision and scale.),
//   auto_increment: bool (Shows if the data type is auto incremental. NULL is returned if the attribute
//                         is not applicable to the data type or the data type is not numeric.),
//   local_type_name: utf8 (Localized version of the data source-dependent name of the data type. NULL
//                          is returned if a localized name is not supported by the data source),
//   minimum_scale: int32 (The minimum scale of the data type on the data source.
//                         If a data type has a fixed scale, the MINIMUM_SCALE and MAXIMUM_SCALE
//                         columns both contain this value. NULL is returned if scale is not applicable.),
//   maximum_scale: int32 (The maximum scale of the data type on the data source.
//                         NULL is returned if scale is not applicable.),
//   sql_data_type: int32 not null (The value of the SQL DATA TYPE which has the same values
//                                  as data_type value. Except for interval and datetime, which
//                                  uses generic values. More info about those types can be
//                                  obtained through datetime_subcode. The possible values can be seen
//                                  in the XdbcDataType enum.),
//   datetime_subcode: int32 (Only used when the SQL DATA TYPE is interval or datetime. It contains
//                            its sub types. For type different from interval and datetime, this value
//                            is NULL. The possible values can be seen in the XdbcDatetimeSubcode enum.),
//   num_prec_radix: int32 (If the data type is an approximate numeric type, this column contains
//                          the value 2 to indicate that COLUMN_SIZE specifies a number of bits. For
//                          exact numeric types, this column contains the value 10 to indicate that
//                          column size specifies a number of decimal digits. Otherwise, this column is NULL.),
//   interval_precision: int32 (If the data type is an interval data type, then this column contains the value
//                              of the interval leading precision. Otherwise, this column is NULL. This fields
//                              is only relevant to be used by ODBC).
// >
// The returned data should be ordered by data_type and then by type_name.
type CommandGetXdbcTypeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Specifies the data type to search for the info.
	DataType *int32 `protobuf:"varint,1,opt,name=data_type,json=dataType,proto3,oneof" json:"data_type,omitempty"`
}

func (x *CommandGetXdbcTypeInfo) Reset() {
	*x = CommandGetXdbcTypeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetXdbcTypeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetXdbcTypeInfo) ProtoMessage() {}

func (x *CommandGetXdbcTypeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetXdbcTypeInfo.ProtoReflect.Descriptor instead.
func (*CommandGetXdbcTypeInfo) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{1}
}

func (x *CommandGetXdbcTypeInfo) GetDataType() int32 {
	if x != nil && x.DataType != nil {
		return *x.DataType
	}
	return 0
}

//
// Represents a request to retrieve the list of catalogs on a Flight SQL enabled backend.
// The definition of a catalog depends on vendor/implementation. It is usually the database itself
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  catalog_name: utf8 not null
// >
// The returned data should be ordered by catalog_name.
type CommandGetCatalogs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommandGetCatalogs) Reset() {
	*x = CommandGetCatalogs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetCatalogs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetCatalogs) ProtoMessage() {}

func (x *CommandGetCatalogs) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetCatalogs.ProtoReflect.Descriptor instead.
func (*CommandGetCatalogs) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{2}
}

//
// Represents a request to retrieve the list of database schemas on a Flight SQL enabled backend.
// The definition of a database schema depends on vendor/implementation. It is usually a collection of tables.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  catalog_name: utf8,
//  db_schema_name: utf8 not null
// >
// The returned data should be ordered by catalog_name, then db_schema_name.
type CommandGetDbSchemas struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Specifies the Catalog to search for the tables.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	Catalog *string `protobuf:"bytes,1,opt,name=catalog,proto3,oneof" json:"catalog,omitempty"`
	//
	// Specifies a filter pattern for schemas to search for.
	// When no db_schema_filter_pattern is provided, the pattern will not be used to narrow the search.
	// In the pattern string, two special characters can be used to denote matching rules:
	//    - "%" means to match any substring with 0 or more characters.
	//    - "_" means to match any one character.
	DbSchemaFilterPattern *string `protobuf:"bytes,2,opt,name=db_schema_filter_pattern,json=dbSchemaFilterPattern,proto3,oneof" json:"db_schema_filter_pattern,omitempty"`
}

func (x *CommandGetDbSchemas) Reset() {
	*x = CommandGetDbSchemas{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetDbSchemas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetDbSchemas) ProtoMessage() {}

func (x *CommandGetDbSchemas) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetDbSchemas.ProtoReflect.Descriptor instead.
func (*CommandGetDbSchemas) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{3}
}

func (x *CommandGetDbSchemas) GetCatalog() string {
	if x != nil && x.Catalog != nil {
		return *x.Catalog
	}
	return ""
}

func (x *CommandGetDbSchemas) GetDbSchemaFilterPattern() string {
	if x != nil && x.DbSchemaFilterPattern != nil {
		return *x.DbSchemaFilterPattern
	}
	return ""
}

//
// Represents a request to retrieve the list of tables, and optionally their schemas, on a Flight SQL enabled backend.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  catalog_name: utf8,
//  db_schema_name: utf8,
//  table_name: utf8 not null,
//  table_type: utf8 not null,
//  [optional] table_schema: bytes not null (schema of the table as described in Schema.fbs::Schema,
//                                           it is serialized as an IPC message.)
// >
// Fields on table_schema may contain the following metadata:
//  - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
//  - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
//  - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
//  - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
//  - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
//  - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
//  - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
//  - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
//  - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
//  - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
// The returned data should be ordered by catalog_name, db_schema_name, table_name, then table_type, followed by table_schema if requested.
type CommandGetTables struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Specifies the Catalog to search for the tables.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	Catalog *string `protobuf:"bytes,1,opt,name=catalog,proto3,oneof" json:"catalog,omitempty"`
	//
	// Specifies a filter pattern for schemas to search for.
	// When no db_schema_filter_pattern is provided, all schemas matching other filters are searched.
	// In the pattern string, two special characters can be used to denote matching rules:
	//    - "%" means to match any substring with 0 or more characters.
	//    - "_" means to match any one character.
	DbSchemaFilterPattern *string `protobuf:"bytes,2,opt,name=db_schema_filter_pattern,json=dbSchemaFilterPattern,proto3,oneof" json:"db_schema_filter_pattern,omitempty"`
	//
	// Specifies a filter pattern for tables to search for.
	// When no table_name_filter_pattern is provided, all tables matching other filters are searched.
	// In the pattern string, two special characters can be used to denote matching rules:
	//    - "%" means to match any substring with 0 or more characters.
	//    - "_" means to match any one character.
	TableNameFilterPattern *string `protobuf:"bytes,3,opt,name=table_name_filter_pattern,json=tableNameFilterPattern,proto3,oneof" json:"table_name_filter_pattern,omitempty"`
	//
	// Specifies a filter of table types which must match.
	// The table types depend on vendor/implementation. It is usually used to separate tables from views or system tables.
	// TABLE, VIEW, and SYSTEM TABLE are commonly supported.
	TableTypes []string `protobuf:"bytes,4,rep,name=table_types,json=tableTypes,proto3" json:"table_types,omitempty"`
	// Specifies if the Arrow schema should be returned for found tables.
	IncludeSchema bool `protobuf:"varint,5,opt,name=include_schema,json=includeSchema,proto3" json:"include_schema,omitempty"`
}

func (x *CommandGetTables) Reset() {
	*x = CommandGetTables{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetTables) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetTables) ProtoMessage() {}

func (x *CommandGetTables) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetTables.ProtoReflect.Descriptor instead.
func (*CommandGetTables) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{4}
}

func (x *CommandGetTables) GetCatalog() string {
	if x != nil && x.Catalog != nil {
		return *x.Catalog
	}
	return ""
}

func (x *CommandGetTables) GetDbSchemaFilterPattern() string {
	if x != nil && x.DbSchemaFilterPattern != nil {
		return *x.DbSchemaFilterPattern
	}
	return ""
}

func (x *CommandGetTables) GetTableNameFilterPattern() string {
	if x != nil && x.TableNameFilterPattern != nil {
		return *x.TableNameFilterPattern
	}
	return ""
}

func (x *CommandGetTables) GetTableTypes() []string {
	if x != nil {
		return x.TableTypes
	}
	return nil
}

func (x *CommandGetTables) GetIncludeSchema() bool {
	if x != nil {
		return x.IncludeSchema
	}
	return false
}

//
// Represents a request to retrieve the list of table types on a Flight SQL enabled backend.
// The table types depend on vendor/implementation. It is usually used to separate tables from views or system tables.
// TABLE, VIEW, and SYSTEM TABLE are commonly supported.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  table_type: utf8 not null
// >
// The returned data should be ordered by table_type.
type CommandGetTableTypes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommandGetTableTypes) Reset() {
	*x = CommandGetTableTypes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetTableTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetTableTypes) ProtoMessage() {}

func (x *CommandGetTableTypes) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetTableTypes.ProtoReflect.Descriptor instead.
func (*CommandGetTableTypes) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{5}
}

//
// Represents a request to retrieve the primary keys of a table on a Flight SQL enabled backend.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  catalog_name: utf8,
//  db_schema_name: utf8,
//  table_name: utf8 not null,
//  column_name: utf8 not null,
//  key_name: utf8,
//  key_sequence: int32 not null
// >
// The returned data should be ordered by catalog_name, db_schema_name, table_name, key_name, then key_sequence.
type CommandGetPrimaryKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Specifies the catalog to search for the table.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	Catalog *string `protobuf:"bytes,1,opt,name=catalog,proto3,oneof" json:"catalog,omitempty"`
	//
	// Specifies the schema to search for the table.
	// An empty string retrieves those without a schema.
	// If omitted the schema name should not be used to narrow the search.
	DbSchema *string `protobuf:"bytes,2,opt,name=db_schema,json=dbSchema,proto3,oneof" json:"db_schema,omitempty"`
	// Specifies the table to get the primary keys for.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *CommandGetPrimaryKeys) Reset() {
	*x = CommandGetPrimaryKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetPrimaryKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetPrimaryKeys) ProtoMessage() {}

func (x *CommandGetPrimaryKeys) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetPrimaryKeys.ProtoReflect.Descriptor instead.
func (*CommandGetPrimaryKeys) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{6}
}

func (x *CommandGetPrimaryKeys) GetCatalog() string {
	if x != nil && x.Catalog != nil {
		return *x.Catalog
	}
	return ""
}

func (x *CommandGetPrimaryKeys) GetDbSchema() string {
	if x != nil && x.DbSchema != nil {
		return *x.DbSchema
	}
	return ""
}

func (x *CommandGetPrimaryKeys) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

//
// Represents a request to retrieve a description of the foreign key columns that reference the given table's
// primary key columns (the foreign keys exported by a table) of a table on a Flight SQL enabled backend.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  pk_catalog_name: utf8,
//  pk_db_schema_name: utf8,
//  pk_table_name: utf8 not null,
//  pk_column_name: utf8 not null,
//  fk_catalog_name: utf8,
//  fk_db_schema_name: utf8,
//  fk_table_name: utf8 not null,
//  fk_column_name: utf8 not null,
//  key_sequence: int32 not null,
//  fk_key_name: utf8,
//  pk_key_name: utf8,
//  update_rule: uint8 not null,
//  delete_rule: uint8 not null
// >
// The returned data should be ordered by fk_catalog_name, fk_db_schema_name, fk_table_name, fk_key_name, then key_sequence.
// update_rule and delete_rule returns a byte that is equivalent to actions declared on UpdateDeleteRules enum.
type CommandGetExportedKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Specifies the catalog to search for the foreign key table.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	Catalog *string `protobuf:"bytes,1,opt,name=catalog,proto3,oneof" json:"catalog,omitempty"`
	//
	// Specifies the schema to search for the foreign key table.
	// An empty string retrieves those without a schema.
	// If omitted the schema name should not be used to narrow the search.
	DbSchema *string `protobuf:"bytes,2,opt,name=db_schema,json=dbSchema,proto3,oneof" json:"db_schema,omitempty"`
	// Specifies the foreign key table to get the foreign keys for.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *CommandGetExportedKeys) Reset() {
	*x = CommandGetExportedKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetExportedKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetExportedKeys) ProtoMessage() {}

func (x *CommandGetExportedKeys) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetExportedKeys.ProtoReflect.Descriptor instead.
func (*CommandGetExportedKeys) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{7}
}

func (x *CommandGetExportedKeys) GetCatalog() string {
	if x != nil && x.Catalog != nil {
		return *x.Catalog
	}
	return ""
}

func (x *CommandGetExportedKeys) GetDbSchema() string {
	if x != nil && x.DbSchema != nil {
		return *x.DbSchema
	}
	return ""
}

func (x *CommandGetExportedKeys) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

//
// Represents a request to retrieve the foreign keys of a table on a Flight SQL enabled backend.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  pk_catalog_name: utf8,
//  pk_db_schema_name: utf8,
//  pk_table_name: utf8 not null,
//  pk_column_name: utf8 not null,
//  fk_catalog_name: utf8,
//  fk_db_schema_name: utf8,
//  fk_table_name: utf8 not null,
//  fk_column_name: utf8 not null,
//  key_sequence: int32 not null,
//  fk_key_name: utf8,
//  pk_key_name: utf8,
//  update_rule: uint8 not null,
//  delete_rule: uint8 not null
// >
// The returned data should be ordered by pk_catalog_name, pk_db_schema_name, pk_table_name, pk_key_name, then key_sequence.
// update_rule and delete_rule returns a byte that is equivalent to actions:
//    - 0 = CASCADE
//    - 1 = RESTRICT
//    - 2 = SET NULL
//    - 3 = NO ACTION
//    - 4 = SET DEFAULT
type CommandGetImportedKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Specifies the catalog to search for the primary key table.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	Catalog *string `protobuf:"bytes,1,opt,name=catalog,proto3,oneof" json:"catalog,omitempty"`
	//
	// Specifies the schema to search for the primary key table.
	// An empty string retrieves those without a schema.
	// If omitted the schema name should not be used to narrow the search.
	DbSchema *string `protobuf:"bytes,2,opt,name=db_schema,json=dbSchema,proto3,oneof" json:"db_schema,omitempty"`
	// Specifies the primary key table to get the foreign keys for.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *CommandGetImportedKeys) Reset() {
	*x = CommandGetImportedKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetImportedKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetImportedKeys) ProtoMessage() {}

func (x *CommandGetImportedKeys) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetImportedKeys.ProtoReflect.Descriptor instead.
func (*CommandGetImportedKeys) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{8}
}

func (x *CommandGetImportedKeys) GetCatalog() string {
	if x != nil && x.Catalog != nil {
		return *x.Catalog
	}
	return ""
}

func (x *CommandGetImportedKeys) GetDbSchema() string {
	if x != nil && x.DbSchema != nil {
		return *x.DbSchema
	}
	return ""
}

func (x *CommandGetImportedKeys) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

//
// Represents a request to retrieve a description of the foreign key columns in the given foreign key table that
// reference the primary key or the columns representing a unique constraint of the parent table (could be the same
// or a different table) on a Flight SQL enabled backend.
// Used in the command member of FlightDescriptor for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//  - GetFlightInfo: execute the catalog metadata request.
//
// The returned Arrow schema will be:
// <
//  pk_catalog_name: utf8,
//  pk_db_schema_name: utf8,
//  pk_table_name: utf8 not null,
//  pk_column_name: utf8 not null,
//  fk_catalog_name: utf8,
//  fk_db_schema_name: utf8,
//  fk_table_name: utf8 not null,
//  fk_column_name: utf8 not null,
//  key_sequence: int32 not null,
//  fk_key_name: utf8,
//  pk_key_name: utf8,
//  update_rule: uint8 not null,
//  delete_rule: uint8 not null
// >
// The returned data should be ordered by pk_catalog_name, pk_db_schema_name, pk_table_name, pk_key_name, then key_sequence.
// update_rule and delete_rule returns a byte that is equivalent to actions:
//    - 0 = CASCADE
//    - 1 = RESTRICT
//    - 2 = SET NULL
//    - 3 = NO ACTION
//    - 4 = SET DEFAULT
type CommandGetCrossReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//*
	// The catalog name where the parent table is.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	PkCatalog *string `protobuf:"bytes,1,opt,name=pk_catalog,json=pkCatalog,proto3,oneof" json:"pk_catalog,omitempty"`
	//*
	// The Schema name where the parent table is.
	// An empty string retrieves those without a schema.
	// If omitted the schema name should not be used to narrow the search.
	PkDbSchema *string `protobuf:"bytes,2,opt,name=pk_db_schema,json=pkDbSchema,proto3,oneof" json:"pk_db_schema,omitempty"`
	//*
	// The parent table name. It cannot be null.
	PkTable string `protobuf:"bytes,3,opt,name=pk_table,json=pkTable,proto3" json:"pk_table,omitempty"`
	//*
	// The catalog name where the foreign table is.
	// An empty string retrieves those without a catalog.
	// If omitted the catalog name should not be used to narrow the search.
	FkCatalog *string `protobuf:"bytes,4,opt,name=fk_catalog,json=fkCatalog,proto3,oneof" json:"fk_catalog,omitempty"`
	//*
	// The schema name where the foreign table is.
	// An empty string retrieves those without a schema.
	// If omitted the schema name should not be used to narrow the search.
	FkDbSchema *string `protobuf:"bytes,5,opt,name=fk_db_schema,json=fkDbSchema,proto3,oneof" json:"fk_db_schema,omitempty"`
	//*
	// The foreign table name. It cannot be null.
	FkTable string `protobuf:"bytes,6,opt,name=fk_table,json=fkTable,proto3" json:"fk_table,omitempty"`
}

func (x *CommandGetCrossReference) Reset() {
	*x = CommandGetCrossReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandGetCrossReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandGetCrossReference) ProtoMessage() {}

func (x *CommandGetCrossReference) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandGetCrossReference.ProtoReflect.Descriptor instead.
func (*CommandGetCrossReference) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{9}
}

func (x *CommandGetCrossReference) GetPkCatalog() string {
	if x != nil && x.PkCatalog != nil {
		return *x.PkCatalog
	}
	return ""
}

func (x *CommandGetCrossReference) GetPkDbSchema() string {
	if x != nil && x.PkDbSchema != nil {
		return *x.PkDbSchema
	}
	return ""
}

func (x *CommandGetCrossReference) GetPkTable() string {
	if x != nil {
		return x.PkTable
	}
	return ""
}

func (x *CommandGetCrossReference) GetFkCatalog() string {
	if x != nil && x.FkCatalog != nil {
		return *x.FkCatalog
	}
	return ""
}

func (x *CommandGetCrossReference) GetFkDbSchema() string {
	if x != nil && x.FkDbSchema != nil {
		return *x.FkDbSchema
	}
	return ""
}

func (x *CommandGetCrossReference) GetFkTable() string {
	if x != nil {
		return x.FkTable
	}
	return ""
}

//
// Request message for the "CreatePreparedStatement" action on a Flight SQL enabled backend.
type ActionCreatePreparedStatementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The valid SQL string to create a prepared statement for.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Create/execute the prepared statement as part of this transaction (if
	// unset, executions of the prepared statement will be auto-committed).
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof" json:"transaction_id,omitempty"`
}

func (x *ActionCreatePreparedStatementRequest) Reset() {
	*x = ActionCreatePreparedStatementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionCreatePreparedStatementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCreatePreparedStatementRequest) ProtoMessage() {}

func (x *ActionCreatePreparedStatementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCreatePreparedStatementRequest.ProtoReflect.Descriptor instead.
func (*ActionCreatePreparedStatementRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{10}
}

func (x *ActionCreatePreparedStatementRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ActionCreatePreparedStatementRequest) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

//
// An embedded message describing a Substrait plan to execute.
type SubstraitPlan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The serialized substrait.Plan to create a prepared statement for.
	// XXX(ARROW-16902): this is bytes instead of an embedded message
	// because Protobuf does not really support one DLL using Protobuf
	// definitions from another DLL.
	Plan []byte `protobuf:"bytes,1,opt,name=plan,proto3" json:"plan,omitempty"`
	// The Substrait release, e.g. "0.12.0". This information is not
	// tracked in the plan itself, so this is the only way for consumers
	// to potentially know if they can handle the plan.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SubstraitPlan) Reset() {
	*x = SubstraitPlan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubstraitPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubstraitPlan) ProtoMessage() {}

func (x *SubstraitPlan) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubstraitPlan.ProtoReflect.Descriptor instead.
func (*SubstraitPlan) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{11}
}

func (x *SubstraitPlan) GetPlan() []byte {
	if x != nil {
		return x.Plan
	}
	return nil
}

func (x *SubstraitPlan) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

//
// Request message for the "CreatePreparedSubstraitPlan" action on a Flight SQL enabled backend.
type ActionCreatePreparedSubstraitPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The serialized substrait.Plan to create a prepared statement for.
	Plan *SubstraitPlan `protobuf:"bytes,1,opt,name=plan,proto3" json:"plan,omitempty"`
	// Create/execute the prepared statement as part of this transaction (if
	// unset, executions of the prepared statement will be auto-committed).
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof" json:"transaction_id,omitempty"`
}

func (x *ActionCreatePreparedSubstraitPlanRequest) Reset() {
	*x = ActionCreatePreparedSubstraitPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionCreatePreparedSubstraitPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCreatePreparedSubstraitPlanRequest) ProtoMessage() {}

func (x *ActionCreatePreparedSubstraitPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCreatePreparedSubstraitPlanRequest.ProtoReflect.Descriptor instead.
func (*ActionCreatePreparedSubstraitPlanRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{12}
}

func (x *ActionCreatePreparedSubstraitPlanRequest) GetPlan() *SubstraitPlan {
	if x != nil {
		return x.Plan
	}
	return nil
}

func (x *ActionCreatePreparedSubstraitPlanRequest) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

//
// Wrap the result of a "CreatePreparedStatement" or "CreatePreparedSubstraitPlan" action.
//
// The resultant PreparedStatement can be closed either:
// - Manually, through the "ClosePreparedStatement" action;
// - Automatically, by a server timeout.
//
// The result should be wrapped in a google.protobuf.Any message.
type ActionCreatePreparedStatementResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the prepared statement on the server.
	PreparedStatementHandle []byte `protobuf:"bytes,1,opt,name=prepared_statement_handle,json=preparedStatementHandle,proto3" json:"prepared_statement_handle,omitempty"`
	// If a result set generating query was provided, dataset_schema contains the
	// schema of the dataset as described in Schema.fbs::Schema, it is serialized as an IPC message.
	DatasetSchema []byte `protobuf:"bytes,2,opt,name=dataset_schema,json=datasetSchema,proto3" json:"dataset_schema,omitempty"`
	// If the query provided contained parameters, parameter_schema contains the
	// schema of the expected parameters as described in Schema.fbs::Schema, it is serialized as an IPC message.
	ParameterSchema []byte `protobuf:"bytes,3,opt,name=parameter_schema,json=parameterSchema,proto3" json:"parameter_schema,omitempty"`
}

func (x *ActionCreatePreparedStatementResult) Reset() {
	*x = ActionCreatePreparedStatementResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionCreatePreparedStatementResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCreatePreparedStatementResult) ProtoMessage() {}

func (x *ActionCreatePreparedStatementResult) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCreatePreparedStatementResult.ProtoReflect.Descriptor instead.
func (*ActionCreatePreparedStatementResult) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{13}
}

func (x *ActionCreatePreparedStatementResult) GetPreparedStatementHandle() []byte {
	if x != nil {
		return x.PreparedStatementHandle
	}
	return nil
}

func (x *ActionCreatePreparedStatementResult) GetDatasetSchema() []byte {
	if x != nil {
		return x.DatasetSchema
	}
	return nil
}

func (x *ActionCreatePreparedStatementResult) GetParameterSchema() []byte {
	if x != nil {
		return x.ParameterSchema
	}
	return nil
}

//
// Request message for the "ClosePreparedStatement" action on a Flight SQL enabled backend.
// Closes server resources associated with the prepared statement handle.
type ActionClosePreparedStatementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the prepared statement on the server.
	PreparedStatementHandle []byte `protobuf:"bytes,1,opt,name=prepared_statement_handle,json=preparedStatementHandle,proto3" json:"prepared_statement_handle,omitempty"`
}

func (x *ActionClosePreparedStatementRequest) Reset() {
	*x = ActionClosePreparedStatementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionClosePreparedStatementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionClosePreparedStatementRequest) ProtoMessage() {}

func (x *ActionClosePreparedStatementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionClosePreparedStatementRequest.ProtoReflect.Descriptor instead.
func (*ActionClosePreparedStatementRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{14}
}

func (x *ActionClosePreparedStatementRequest) GetPreparedStatementHandle() []byte {
	if x != nil {
		return x.PreparedStatementHandle
	}
	return nil
}

//
// Request message for the "BeginTransaction" action.
// Begins a transaction.
type ActionBeginTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ActionBeginTransactionRequest) Reset() {
	*x = ActionBeginTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionBeginTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionBeginTransactionRequest) ProtoMessage() {}

func (x *ActionBeginTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionBeginTransactionRequest.ProtoReflect.Descriptor instead.
func (*ActionBeginTransactionRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{15}
}

//
// Request message for the "BeginSavepoint" action.
// Creates a savepoint within a transaction.
//
// Only supported if FLIGHT_SQL_TRANSACTION is
// FLIGHT_SQL_TRANSACTION_SUPPORT_SAVEPOINT.
type ActionBeginSavepointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transaction to which a savepoint belongs.
	TransactionId []byte `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	// Name for the savepoint.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ActionBeginSavepointRequest) Reset() {
	*x = ActionBeginSavepointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionBeginSavepointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionBeginSavepointRequest) ProtoMessage() {}

func (x *ActionBeginSavepointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionBeginSavepointRequest.ProtoReflect.Descriptor instead.
func (*ActionBeginSavepointRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{16}
}

func (x *ActionBeginSavepointRequest) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

func (x *ActionBeginSavepointRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

//
// The result of a "BeginTransaction" action.
//
// The transaction can be manipulated with the "EndTransaction" action, or
// automatically via server timeout. If the transaction times out, then it is
// automatically rolled back.
//
// The result should be wrapped in a google.protobuf.Any message.
type ActionBeginTransactionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the transaction on the server.
	TransactionId []byte `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *ActionBeginTransactionResult) Reset() {
	*x = ActionBeginTransactionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionBeginTransactionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionBeginTransactionResult) ProtoMessage() {}

func (x *ActionBeginTransactionResult) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionBeginTransactionResult.ProtoReflect.Descriptor instead.
func (*ActionBeginTransactionResult) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{17}
}

func (x *ActionBeginTransactionResult) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

//
// The result of a "BeginSavepoint" action.
//
// The transaction can be manipulated with the "EndSavepoint" action.
// If the associated transaction is committed, rolled back, or times
// out, then the savepoint is also invalidated.
//
// The result should be wrapped in a google.protobuf.Any message.
type ActionBeginSavepointResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the savepoint on the server.
	SavepointId []byte `protobuf:"bytes,1,opt,name=savepoint_id,json=savepointId,proto3" json:"savepoint_id,omitempty"`
}

func (x *ActionBeginSavepointResult) Reset() {
	*x = ActionBeginSavepointResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionBeginSavepointResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionBeginSavepointResult) ProtoMessage() {}

func (x *ActionBeginSavepointResult) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionBeginSavepointResult.ProtoReflect.Descriptor instead.
func (*ActionBeginSavepointResult) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{18}
}

func (x *ActionBeginSavepointResult) GetSavepointId() []byte {
	if x != nil {
		return x.SavepointId
	}
	return nil
}

//
// Request message for the "EndTransaction" action.
//
// Commit (COMMIT) or rollback (ROLLBACK) the transaction.
//
// If the action completes successfully, the transaction handle is
// invalidated, as are all associated savepoints.
type ActionEndTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the transaction on the server.
	TransactionId []byte `protobuf:"bytes,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	// Whether to commit/rollback the given transaction.
	Action ActionEndTransactionRequest_EndTransaction `protobuf:"varint,2,opt,name=action,proto3,enum=arrow.flight.protocol.sql.ActionEndTransactionRequest_EndTransaction" json:"action,omitempty"`
}

func (x *ActionEndTransactionRequest) Reset() {
	*x = ActionEndTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionEndTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionEndTransactionRequest) ProtoMessage() {}

func (x *ActionEndTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionEndTransactionRequest.ProtoReflect.Descriptor instead.
func (*ActionEndTransactionRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{19}
}

func (x *ActionEndTransactionRequest) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

func (x *ActionEndTransactionRequest) GetAction() ActionEndTransactionRequest_EndTransaction {
	if x != nil {
		return x.Action
	}
	return ActionEndTransactionRequest_END_TRANSACTION_UNSPECIFIED
}

//
// Request message for the "EndSavepoint" action.
//
// Release (RELEASE) the savepoint or rollback (ROLLBACK) to the
// savepoint.
//
// Releasing a savepoint invalidates that savepoint.  Rolling back to
// a savepoint does not invalidate the savepoint, but invalidates all
// savepoints created after the current savepoint.
type ActionEndSavepointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the savepoint on the server.
	SavepointId []byte `protobuf:"bytes,1,opt,name=savepoint_id,json=savepointId,proto3" json:"savepoint_id,omitempty"`
	// Whether to rollback/release the given savepoint.
	Action ActionEndSavepointRequest_EndSavepoint `protobuf:"varint,2,opt,name=action,proto3,enum=arrow.flight.protocol.sql.ActionEndSavepointRequest_EndSavepoint" json:"action,omitempty"`
}

func (x *ActionEndSavepointRequest) Reset() {
	*x = ActionEndSavepointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionEndSavepointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionEndSavepointRequest) ProtoMessage() {}

func (x *ActionEndSavepointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionEndSavepointRequest.ProtoReflect.Descriptor instead.
func (*ActionEndSavepointRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{20}
}

func (x *ActionEndSavepointRequest) GetSavepointId() []byte {
	if x != nil {
		return x.SavepointId
	}
	return nil
}

func (x *ActionEndSavepointRequest) GetAction() ActionEndSavepointRequest_EndSavepoint {
	if x != nil {
		return x.Action
	}
	return ActionEndSavepointRequest_END_SAVEPOINT_UNSPECIFIED
}

//
// Represents a SQL query. Used in the command member of FlightDescriptor
// for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//    Fields on this schema may contain the following metadata:
//    - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
//    - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
//    - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
//    - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
//    - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
//    - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
//    - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
//  - GetFlightInfo: execute the query.
type CommandStatementQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL syntax.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Include the query as part of this transaction (if unset, the query is auto-committed).
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof" json:"transaction_id,omitempty"`
}

func (x *CommandStatementQuery) Reset() {
	*x = CommandStatementQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandStatementQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandStatementQuery) ProtoMessage() {}

func (x *CommandStatementQuery) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandStatementQuery.ProtoReflect.Descriptor instead.
func (*CommandStatementQuery) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{21}
}

func (x *CommandStatementQuery) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *CommandStatementQuery) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

//
// Represents a Substrait plan. Used in the command member of FlightDescriptor
// for the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//    Fields on this schema may contain the following metadata:
//    - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
//    - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
//    - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
//    - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
//    - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
//    - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
//    - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
//  - GetFlightInfo: execute the query.
//  - DoPut: execute the query.
type CommandStatementSubstraitPlan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A serialized substrait.Plan
	Plan *SubstraitPlan `protobuf:"bytes,1,opt,name=plan,proto3" json:"plan,omitempty"`
	// Include the query as part of this transaction (if unset, the query is auto-committed).
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof" json:"transaction_id,omitempty"`
}

func (x *CommandStatementSubstraitPlan) Reset() {
	*x = CommandStatementSubstraitPlan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandStatementSubstraitPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandStatementSubstraitPlan) ProtoMessage() {}

func (x *CommandStatementSubstraitPlan) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandStatementSubstraitPlan.ProtoReflect.Descriptor instead.
func (*CommandStatementSubstraitPlan) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{22}
}

func (x *CommandStatementSubstraitPlan) GetPlan() *SubstraitPlan {
	if x != nil {
		return x.Plan
	}
	return nil
}

func (x *CommandStatementSubstraitPlan) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

//*
// Represents a ticket resulting from GetFlightInfo with a CommandStatementQuery.
// This should be used only once and treated as an opaque value, that is, clients should not attempt to parse this.
type TicketStatementQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the instance of the statement to execute.
	StatementHandle []byte `protobuf:"bytes,1,opt,name=statement_handle,json=statementHandle,proto3" json:"statement_handle,omitempty"`
}

func (x *TicketStatementQuery) Reset() {
	*x = TicketStatementQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TicketStatementQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TicketStatementQuery) ProtoMessage() {}

func (x *TicketStatementQuery) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TicketStatementQuery.ProtoReflect.Descriptor instead.
func (*TicketStatementQuery) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{23}
}

func (x *TicketStatementQuery) GetStatementHandle() []byte {
	if x != nil {
		return x.StatementHandle
	}
	return nil
}

//
// Represents an instance of executing a prepared statement. Used in the command member of FlightDescriptor for
// the following RPC calls:
//  - GetSchema: return the Arrow schema of the query.
//    Fields on this schema may contain the following metadata:
//    - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
//    - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
//    - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
//    - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
//    - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
//    - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
//    - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
//    - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
//  - DoPut: bind parameter values. All of the bound parameter sets will be executed as a single atomic execution.
//  - GetFlightInfo: execute the prepared statement instance.
type CommandPreparedStatementQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the prepared statement on the server.
	PreparedStatementHandle []byte `protobuf:"bytes,1,opt,name=prepared_statement_handle,json=preparedStatementHandle,proto3" json:"prepared_statement_handle,omitempty"`
}

func (x *CommandPreparedStatementQuery) Reset() {
	*x = CommandPreparedStatementQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandPreparedStatementQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandPreparedStatementQuery) ProtoMessage() {}

func (x *CommandPreparedStatementQuery) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandPreparedStatementQuery.ProtoReflect.Descriptor instead.
func (*CommandPreparedStatementQuery) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{24}
}

func (x *CommandPreparedStatementQuery) GetPreparedStatementHandle() []byte {
	if x != nil {
		return x.PreparedStatementHandle
	}
	return nil
}

//
// Represents a SQL update query. Used in the command member of FlightDescriptor
// for the RPC call DoPut to cause the server to execute the included SQL update.
type CommandStatementUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL syntax.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Include the query as part of this transaction (if unset, the query is auto-committed).
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof" json:"transaction_id,omitempty"`
}

func (x *CommandStatementUpdate) Reset() {
	*x = CommandStatementUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandStatementUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandStatementUpdate) ProtoMessage() {}

func (x *CommandStatementUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandStatementUpdate.ProtoReflect.Descriptor instead.
func (*CommandStatementUpdate) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{25}
}

func (x *CommandStatementUpdate) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *CommandStatementUpdate) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

//
// Represents a SQL update query. Used in the command member of FlightDescriptor
// for the RPC call DoPut to cause the server to execute the included
// prepared statement handle as an update.
type CommandPreparedStatementUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque handle for the prepared statement on the server.
	PreparedStatementHandle []byte `protobuf:"bytes,1,opt,name=prepared_statement_handle,json=preparedStatementHandle,proto3" json:"prepared_statement_handle,omitempty"`
}

func (x *CommandPreparedStatementUpdate) Reset() {
	*x = CommandPreparedStatementUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandPreparedStatementUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandPreparedStatementUpdate) ProtoMessage() {}

func (x *CommandPreparedStatementUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandPreparedStatementUpdate.ProtoReflect.Descriptor instead.
func (*CommandPreparedStatementUpdate) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{26}
}

func (x *CommandPreparedStatementUpdate) GetPreparedStatementHandle() []byte {
	if x != nil {
		return x.PreparedStatementHandle
	}
	return nil
}

//
// Returned from the RPC call DoPut when a CommandStatementUpdate
// CommandPreparedStatementUpdate was in the request, containing
// results from the update.
type DoPutUpdateResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of records updated. A return value of -1 represents
	// an unknown updated record count.
	RecordCount int64 `protobuf:"varint,1,opt,name=record_count,json=recordCount,proto3" json:"record_count,omitempty"`
}

func (x *DoPutUpdateResult) Reset() {
	*x = DoPutUpdateResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoPutUpdateResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoPutUpdateResult) ProtoMessage() {}

func (x *DoPutUpdateResult) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoPutUpdateResult.ProtoReflect.Descriptor instead.
func (*DoPutUpdateResult) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{27}
}

func (x *DoPutUpdateResult) GetRecordCount() int64 {
	if x != nil {
		return x.RecordCount
	}
	return 0
}

//
// Request message for the "CancelQuery" action.
//
// Explicitly cancel a running query.
//
// This lets a single client explicitly cancel work, no matter how many clients
// are involved/whether the query is distributed or not, given server support.
// The transaction/statement is not rolled back; it is the application's job to
// commit or rollback as appropriate. This only indicates the client no longer
// wishes to read the remainder of the query results or continue submitting
// data.
//
// This command is idempotent.
//
// This command is deprecated since 13.0.0. Use the "CancelFlightInfo"
// action with DoAction instead.
//
// Deprecated: Do not use.
type ActionCancelQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the GetFlightInfo RPC that initiated the query.
	// XXX(ARROW-16902): this must be a serialized FlightInfo, but is
	// rendered as bytes because Protobuf does not really support one
	// DLL using Protobuf definitions from another DLL.
	Info []byte `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
}

func (x *ActionCancelQueryRequest) Reset() {
	*x = ActionCancelQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionCancelQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCancelQueryRequest) ProtoMessage() {}

func (x *ActionCancelQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCancelQueryRequest.ProtoReflect.Descriptor instead.
func (*ActionCancelQueryRequest) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{28}
}

func (x *ActionCancelQueryRequest) GetInfo() []byte {
	if x != nil {
		return x.Info
	}
	return nil
}

//
// The result of cancelling a query.
//
// The result should be wrapped in a google.protobuf.Any message.
//
// This command is deprecated since 13.0.0. Use the "CancelFlightInfo"
// action with DoAction instead.
//
// Deprecated: Do not use.
type ActionCancelQueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result ActionCancelQueryResult_CancelResult `protobuf:"varint,1,opt,name=result,proto3,enum=arrow.flight.protocol.sql.ActionCancelQueryResult_CancelResult" json:"result,omitempty"`
}

func (x *ActionCancelQueryResult) Reset() {
	*x = ActionCancelQueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_FlightSql_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionCancelQueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionCancelQueryResult) ProtoMessage() {}

func (x *ActionCancelQueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_FlightSql_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionCancelQueryResult.ProtoReflect.Descriptor instead.
func (*ActionCancelQueryResult) Descriptor() ([]byte, []int) {
	return file_FlightSql_proto_rawDescGZIP(), []int{29}
}

func (x *ActionCancelQueryResult) GetResult() ActionCancelQueryResult_CancelResult {
	if x != nil {
		return x.Result
	}
	return ActionCancelQueryResult_CANCEL_RESULT_UNSPECIFIED
}

var file_FlightSql_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptorpb.MessageOptions)(nil),
		ExtensionType: (*bool)(nil),
		Field:         1000,
		Name:          "arrow.flight.protocol.sql.experimental",
		Tag:           "varint,1000,opt,name=experimental",
		Filename:      "FlightSql.proto",
	},
}

// Extension fields to descriptorpb.MessageOptions.
var (
	// optional bool experimental = 1000;
	E_Experimental = &file_FlightSql_proto_extTypes[0]
)

var File_FlightSql_proto protoreflect.FileDescriptor

var file_FlightSql_proto_rawDesc = []byte{
	0x0a, 0x0f, 0x46, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x71, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x19, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x73, 0x71, 0x6c, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2c,
	0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0d, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x4d, 0x0a, 0x16,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x58, 0x64, 0x62, 0x63, 0x54, 0x79,
	0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x64, 0x61, 0x74,
	0x61, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x19, 0x0a, 0x12, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x73, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0xa0, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x47, 0x65, 0x74, 0x44, 0x62, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x1d,
	0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a,
	0x18, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x15, 0x64, 0x62, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01,
	0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x42, 0x1b, 0x0a, 0x19,
	0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22, 0xc3, 0x02, 0x0a, 0x10, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x1d,
	0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a,
	0x18, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x15, 0x64, 0x62, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x19, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02,
	0x52, 0x16, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x0b, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x22,
	0x1b, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x8d, 0x01, 0x0a,
	0x15, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x08, 0x64, 0x62, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x03, 0xc0,
	0x3e, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x42, 0x0c,
	0x0a, 0x0a, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x8e, 0x01, 0x0a,
	0x16, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x08, 0x64, 0x62, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x03,
	0xc0, 0x3e, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x8e, 0x01,
	0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x62, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x08, 0x64, 0x62,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a,
	0x03, 0xc0, 0x3e, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0xab,
	0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x47, 0x65, 0x74, 0x43, 0x72, 0x6f,
	0x73, 0x73, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x6b, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x09, 0x70, 0x6b, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x88, 0x01, 0x01, 0x12,
	0x25, 0x0a, 0x0c, 0x70, 0x6b, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0a, 0x70, 0x6b, 0x44, 0x62, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6b, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6b, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x6b, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x09, 0x66, 0x6b, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0c, 0x66, 0x6b, 0x5f, 0x64, 0x62, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x0a, 0x66,
	0x6b, 0x44, 0x62, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x08,
	0x66, 0x6b, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x66, 0x6b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x70, 0x6b, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x42, 0x0f, 0x0a, 0x0d, 0x5f,
	0x70, 0x6b, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x66, 0x6b, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x42, 0x0f, 0x0a, 0x0d, 0x5f,
	0x66, 0x6b, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x80, 0x01, 0x0a,
	0x24, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x65,
	0x70, 0x61, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2a, 0x0a, 0x0e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42, 0x11, 0x0a, 0x0f,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x22,
	0x42, 0x0a, 0x0d, 0x53, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04,
	0x70, 0x6c, 0x61, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x03,
	0xc0, 0x3e, 0x01, 0x22, 0xac, 0x01, 0x0a, 0x28, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x53, 0x75, 0x62, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x2a,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x22, 0xb8, 0x01, 0x0a, 0x23, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x17, 0x70,
	0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x29, 0x0a,
	0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x66, 0x0a,
	0x23, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x50, 0x72, 0x65, 0x70,
	0x61, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x17, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x24, 0x0a, 0x1d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x5d, 0x0a, 0x1b, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x53, 0x61, 0x76, 0x65, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x4a, 0x0a, 0x1c, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x44, 0x0a, 0x1a, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x65, 0x67, 0x69, 0x6e, 0x53, 0x61, 0x76, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x73, 0x61, 0x76, 0x65,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x64, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x95, 0x02, 0x0a,
	0x1b, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x5d, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c, 0x69, 0x67,
	0x68, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10,
	0x01, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x3a,
	0x03, 0xc0, 0x3e, 0x01, 0x22, 0x84, 0x02, 0x0a, 0x19, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x64, 0x53, 0x61, 0x76, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x59, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c,
	0x69, 0x67, 0x68, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x53, 0x61, 0x76, 0x65, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x53,
	0x61, 0x76, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x64, 0x0a, 0x0c, 0x45, 0x6e, 0x64, 0x53, 0x61, 0x76, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x1d, 0x0a, 0x19, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x50, 0x4f, 0x49, 0x4e,
	0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x19, 0x0a, 0x15, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x50, 0x4f, 0x49, 0x4e, 0x54,
	0x5f, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e,
	0x44, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x52, 0x4f, 0x4c, 0x4c,
	0x42, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x71, 0x0a, 0x15, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0xa1,
	0x01, 0x0a, 0x1d, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x75, 0x62, 0x73, 0x74, 0x72, 0x61, 0x69, 0x74, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x3c, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x12, 0x2a,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x22, 0x46, 0x0a, 0x14, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x60, 0x0a, 0x1d, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3a, 0x0a, 0x19, 0x70,
	0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x17,
	0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x22, 0x72, 0x0a, 0x16,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2a, 0x0a, 0x0e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x3a, 0x03, 0xc0, 0x3e, 0x01, 0x42, 0x11, 0x0a,
	0x0f, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x22, 0x61, 0x0a, 0x1e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x65, 0x70, 0x61,
	0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x17, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x3a, 0x03,
	0xc0, 0x3e, 0x01, 0x22, 0x3b, 0x0a, 0x11, 0x44, 0x6f, 0x50, 0x75, 0x74, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x03, 0xc0, 0x3e, 0x01,
	0x22, 0x35, 0x0a, 0x18, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x3a, 0x05, 0x18, 0x01, 0xc0, 0x3e, 0x01, 0x22, 0x87, 0x02, 0x0a, 0x17, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c, 0x69, 0x67,
	0x68, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x8b, 0x01, 0x0a,
	0x0c, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a,
	0x19, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x3a, 0x05, 0x18, 0x01, 0xc0, 0x3e,
	0x01, 0x2a, 0xb7, 0x18, 0x0a, 0x07, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a,
	0x16, 0x46, 0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x52, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x4c, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x46, 0x4c, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x52,
	0x52, 0x4f, 0x57, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x1f, 0x0a,
	0x1b, 0x46, 0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x52, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x19,
	0x0a, 0x15, 0x46, 0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x45, 0x52, 0x5f, 0x53, 0x51, 0x4c, 0x10, 0x04, 0x12, 0x1f, 0x0a, 0x1b, 0x46, 0x4c, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53,
	0x55, 0x42, 0x53, 0x54, 0x52, 0x41, 0x49, 0x54, 0x10, 0x05, 0x12, 0x2b, 0x0a, 0x27, 0x46, 0x4c,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f,
	0x53, 0x55, 0x42, 0x53, 0x54, 0x52, 0x41, 0x49, 0x54, 0x5f, 0x4d, 0x49, 0x4e, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x2b, 0x0a, 0x27, 0x46, 0x4c, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x42,
	0x53, 0x54, 0x52, 0x41, 0x49, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49,
	0x4f, 0x4e, 0x10, 0x07, 0x12, 0x21, 0x0a, 0x1d, 0x46, 0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x53,
	0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x1c, 0x0a, 0x18, 0x46, 0x4c, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x10, 0x09, 0x12, 0x27, 0x0a, 0x23, 0x46, 0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x64, 0x12, 0x29,
	0x0a, 0x25, 0x46, 0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x45, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x65, 0x12, 0x14, 0x0a, 0x0f, 0x53, 0x51, 0x4c,
	0x5f, 0x44, 0x44, 0x4c, 0x5f, 0x43, 0x41, 0x54, 0x41, 0x4c, 0x4f, 0x47, 0x10, 0xf4, 0x03, 0x12,
	0x13, 0x0a, 0x0e, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x44, 0x4c, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d,
	0x41, 0x10, 0xf5, 0x03, 0x12, 0x12, 0x0a, 0x0d, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x44, 0x4c, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0xf6, 0x03, 0x12, 0x18, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x5f,
	0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x10,
	0xf7, 0x03, 0x12, 0x1e, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49,
	0x46, 0x49, 0x45, 0x52, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10,
	0xf8, 0x03, 0x12, 0x1f, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x45, 0x44,
	0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45,
	0x10, 0xf9, 0x03, 0x12, 0x22, 0x0a, 0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x53, 0x5f, 0x41, 0x52, 0x45, 0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0xfa, 0x03, 0x12, 0x16, 0x0a, 0x11, 0x53, 0x51, 0x4c, 0x5f, 0x4e,
	0x55, 0x4c, 0x4c, 0x5f, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0xfb, 0x03, 0x12,
	0x11, 0x0a, 0x0c, 0x53, 0x51, 0x4c, 0x5f, 0x4b, 0x45, 0x59, 0x57, 0x4f, 0x52, 0x44, 0x53, 0x10,
	0xfc, 0x03, 0x12, 0x1a, 0x0a, 0x15, 0x53, 0x51, 0x4c, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49,
	0x43, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0xfd, 0x03, 0x12, 0x19,
	0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x55, 0x4e,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0xfe, 0x03, 0x12, 0x19, 0x0a, 0x14, 0x53, 0x51, 0x4c,
	0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x53, 0x10, 0xff, 0x03, 0x12, 0x1b, 0x0a, 0x16, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x45,
	0x54, 0x49, 0x4d, 0x45, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x80,
	0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f,
	0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x53, 0x43, 0x41, 0x50, 0x45, 0x10, 0x81, 0x04,
	0x12, 0x1e, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x5f, 0x45, 0x58, 0x54, 0x52, 0x41, 0x5f, 0x4e, 0x41,
	0x4d, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52, 0x53, 0x10, 0x82, 0x04,
	0x12, 0x21, 0x0a, 0x1c, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53,
	0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x41, 0x4c, 0x49, 0x41, 0x53, 0x49, 0x4e, 0x47,
	0x10, 0x83, 0x04, 0x12, 0x1f, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x5f,
	0x50, 0x4c, 0x55, 0x53, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x5f, 0x49, 0x53, 0x5f, 0x4e, 0x55, 0x4c,
	0x4c, 0x10, 0x84, 0x04, 0x12, 0x19, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x10, 0x85, 0x04, 0x12,
	0x29, 0x0a, 0x24, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x86, 0x04, 0x12, 0x33, 0x0a, 0x2e, 0x53, 0x51,
	0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f, 0x44, 0x49, 0x46, 0x46, 0x45,
	0x52, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45,
	0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x87, 0x04, 0x12,
	0x29, 0x0a, 0x24, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f,
	0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x4f,
	0x52, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x10, 0x88, 0x04, 0x12, 0x24, 0x0a, 0x1f, 0x53, 0x51,
	0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f, 0x4f, 0x52, 0x44, 0x45, 0x52,
	0x5f, 0x42, 0x59, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x45, 0x44, 0x10, 0x89, 0x04,
	0x12, 0x1b, 0x0a, 0x16, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x42, 0x59, 0x10, 0x8a, 0x04, 0x12, 0x24, 0x0a,
	0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f, 0x4c, 0x49,
	0x4b, 0x45, 0x5f, 0x45, 0x53, 0x43, 0x41, 0x50, 0x45, 0x5f, 0x43, 0x4c, 0x41, 0x55, 0x53, 0x45,
	0x10, 0x8b, 0x04, 0x12, 0x26, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f,
	0x52, 0x54, 0x53, 0x5f, 0x4e, 0x4f, 0x4e, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x10, 0x8c, 0x04, 0x12, 0x1a, 0x0a, 0x15, 0x53,
	0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x47, 0x52, 0x41,
	0x4d, 0x4d, 0x41, 0x52, 0x10, 0x8d, 0x04, 0x12, 0x1f, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x41,
	0x4e, 0x53, 0x49, 0x39, 0x32, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x8e, 0x04, 0x12, 0x30, 0x0a, 0x2b, 0x53, 0x51, 0x4c, 0x5f,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x45, 0x4e, 0x48, 0x41, 0x4e, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46,
	0x41, 0x43, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x8f, 0x04, 0x12, 0x22, 0x0a, 0x1d, 0x53, 0x51,
	0x4c, 0x5f, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x5f, 0x4a, 0x4f, 0x49, 0x4e, 0x53, 0x5f, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x90, 0x04, 0x12, 0x14,
	0x0a, 0x0f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x54, 0x45, 0x52,
	0x4d, 0x10, 0x91, 0x04, 0x12, 0x17, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x43,
	0x45, 0x44, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x10, 0x92, 0x04, 0x12, 0x15, 0x0a,
	0x10, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x54, 0x41, 0x4c, 0x4f, 0x47, 0x5f, 0x54, 0x45, 0x52,
	0x4d, 0x10, 0x93, 0x04, 0x12, 0x19, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x54, 0x41,
	0x4c, 0x4f, 0x47, 0x5f, 0x41, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x94, 0x04, 0x12,
	0x22, 0x0a, 0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x53, 0x5f, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x10, 0x95, 0x04, 0x12, 0x23, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x54, 0x41, 0x4c,
	0x4f, 0x47, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x96, 0x04, 0x12, 0x26, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x53, 0x10, 0x97, 0x04,
	0x12, 0x24, 0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x5f, 0x46,
	0x4f, 0x52, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x10, 0x98, 0x04, 0x12, 0x24, 0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x54,
	0x4f, 0x52, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52, 0x45, 0x53, 0x5f,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x99, 0x04, 0x12, 0x1d, 0x0a, 0x18,
	0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x55,
	0x42, 0x51, 0x55, 0x45, 0x52, 0x49, 0x45, 0x53, 0x10, 0x9a, 0x04, 0x12, 0x28, 0x0a, 0x23, 0x53,
	0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x55,
	0x42, 0x51, 0x55, 0x45, 0x52, 0x49, 0x45, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x9b, 0x04, 0x12, 0x19, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x55, 0x4e, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x9c, 0x04,
	0x12, 0x22, 0x0a, 0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x42, 0x49, 0x4e, 0x41,
	0x52, 0x59, 0x5f, 0x4c, 0x49, 0x54, 0x45, 0x52, 0x41, 0x4c, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54,
	0x48, 0x10, 0x9d, 0x04, 0x12, 0x20, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f,
	0x43, 0x48, 0x41, 0x52, 0x5f, 0x4c, 0x49, 0x54, 0x45, 0x52, 0x41, 0x4c, 0x5f, 0x4c, 0x45, 0x4e,
	0x47, 0x54, 0x48, 0x10, 0x9e, 0x04, 0x12, 0x1f, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41,
	0x58, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4c, 0x45,
	0x4e, 0x47, 0x54, 0x48, 0x10, 0x9f, 0x04, 0x12, 0x20, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x5f, 0x4d,
	0x41, 0x58, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x47, 0x52,
	0x4f, 0x55, 0x50, 0x5f, 0x42, 0x59, 0x10, 0xa0, 0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51, 0x4c,
	0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x5f, 0x49, 0x4e, 0x5f,
	0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0xa1, 0x04, 0x12, 0x20, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x5f,
	0x4d, 0x41, 0x58, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x4f,
	0x52, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x10, 0xa2, 0x04, 0x12, 0x1e, 0x0a, 0x19, 0x53, 0x51,
	0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x5f, 0x49, 0x4e,
	0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x10, 0xa3, 0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51,
	0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x53, 0x5f, 0x49, 0x4e,
	0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0xa4, 0x04, 0x12, 0x18, 0x0a, 0x13, 0x53, 0x51, 0x4c,
	0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x10, 0xa5, 0x04, 0x12, 0x1f, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x43,
	0x55, 0x52, 0x53, 0x4f, 0x52, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54,
	0x48, 0x10, 0xa6, 0x04, 0x12, 0x19, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f,
	0x49, 0x4e, 0x44, 0x45, 0x58, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48, 0x10, 0xa7, 0x04, 0x12,
	0x1e, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x42, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41,
	0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48, 0x10, 0xa8, 0x04, 0x12,
	0x22, 0x0a, 0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45,
	0x44, 0x55, 0x52, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48,
	0x10, 0xa9, 0x04, 0x12, 0x20, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x43,
	0x41, 0x54, 0x41, 0x4c, 0x4f, 0x47, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47,
	0x54, 0x48, 0x10, 0xaa, 0x04, 0x12, 0x15, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58,
	0x5f, 0x52, 0x4f, 0x57, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10, 0xab, 0x04, 0x12, 0x24, 0x0a, 0x1f,
	0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x52, 0x4f, 0x57, 0x5f, 0x53, 0x49, 0x5a, 0x45,
	0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x53, 0x5f, 0x42, 0x4c, 0x4f, 0x42, 0x53, 0x10,
	0xac, 0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48, 0x10, 0xad,
	0x04, 0x12, 0x17, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x10, 0xae, 0x04, 0x12, 0x1e, 0x0a, 0x19, 0x53, 0x51,
	0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45,
	0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48, 0x10, 0xaf, 0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51,
	0x4c, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x5f,
	0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x10, 0xb0, 0x04, 0x12, 0x1c, 0x0a, 0x17, 0x53, 0x51, 0x4c,
	0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4c, 0x45,
	0x4e, 0x47, 0x54, 0x48, 0x10, 0xb1, 0x04, 0x12, 0x26, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x44,
	0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x49, 0x53, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0xb2, 0x04, 0x12,
	0x1f, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0xb3, 0x04,
	0x12, 0x30, 0x0a, 0x2b, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x49,
	0x53, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x53, 0x10,
	0xb4, 0x04, 0x12, 0x32, 0x0a, 0x2d, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x44,
	0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x45, 0x53,
	0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4d,
	0x4d, 0x49, 0x54, 0x10, 0xb5, 0x04, 0x12, 0x31, 0x0a, 0x2c, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x49,
	0x4e, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x49,
	0x47, 0x4e, 0x4f, 0x52, 0x45, 0x44, 0x10, 0xb6, 0x04, 0x12, 0x23, 0x0a, 0x1e, 0x53, 0x51, 0x4c,
	0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c,
	0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x10, 0xb7, 0x04, 0x12, 0x3b,
	0x0a, 0x36, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x43, 0x4f, 0x4e, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x49, 0x45, 0x53, 0x5f, 0x46, 0x4f,
	0x52, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0xb8, 0x04, 0x12, 0x3c, 0x0a, 0x37, 0x53,
	0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e,
	0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x49, 0x45, 0x53, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x52,
	0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52,
	0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0xb9, 0x04, 0x12, 0x40, 0x0a, 0x3b, 0x53, 0x51, 0x4c,
	0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x43, 0x55,
	0x52, 0x52, 0x45, 0x4e, 0x43, 0x49, 0x45, 0x53, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x53,
	0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x43, 0x52, 0x4f, 0x4c, 0x4c, 0x5f, 0x53,
	0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0xba, 0x04, 0x12, 0x42, 0x0a, 0x3d, 0x53,
	0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e,
	0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x49, 0x45, 0x53, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x52,
	0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x43, 0x52, 0x4f, 0x4c, 0x4c,
	0x5f, 0x49, 0x4e, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0xbb, 0x04, 0x12,
	0x20, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x5f, 0x42, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x45, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0xbc,
	0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x50, 0x4f, 0x49,
	0x4e, 0x54, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0xbd, 0x04,
	0x12, 0x23, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x44, 0x5f, 0x50, 0x41,
	0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0xbe, 0x04, 0x12, 0x1d, 0x0a, 0x18, 0x53, 0x51, 0x4c, 0x5f, 0x4c, 0x4f, 0x43,
	0x41, 0x54, 0x4f, 0x52, 0x53, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x50,
	0x59, 0x10, 0xbf, 0x04, 0x12, 0x35, 0x0a, 0x30, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x54, 0x4f, 0x52,
	0x45, 0x44, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x55, 0x53, 0x49,
	0x4e, 0x47, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x54, 0x41, 0x58, 0x5f, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0xc0, 0x04, 0x2a, 0x91, 0x01, 0x0a, 0x17,
	0x53, 0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x29, 0x0a, 0x25, 0x53,
	0x51, 0x4c, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x2a,
	0xb2, 0x01, 0x0a, 0x1b, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x43, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12,
	0x20, 0x0a, 0x1c, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x53, 0x45, 0x4e, 0x53,
	0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x29, 0x0a, 0x25, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x53, 0x45,
	0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x49,
	0x4e, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e,
	0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49,
	0x56, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52, 0x43, 0x41, 0x53, 0x45, 0x10, 0x02,
	0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x53, 0x45, 0x4e,
	0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x45, 0x52, 0x43, 0x41,
	0x53, 0x45, 0x10, 0x03, 0x2a, 0x82, 0x01, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x4e, 0x75, 0x6c, 0x6c,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x51, 0x4c, 0x5f,
	0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x53, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x48, 0x49, 0x47,
	0x48, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53,
	0x5f, 0x53, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x1d, 0x0a,
	0x19, 0x53, 0x51, 0x4c, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x53, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x5f, 0x41, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17,
	0x53, 0x51, 0x4c, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x5f, 0x53, 0x4f, 0x52, 0x54, 0x45, 0x44,
	0x5f, 0x41, 0x54, 0x5f, 0x45, 0x4e, 0x44, 0x10, 0x03, 0x2a, 0x5e, 0x0a, 0x13, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x71, 0x6c, 0x47, 0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72,
	0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x5f, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x55, 0x4d, 0x5f,
	0x47, 0x52, 0x41, 0x4d, 0x4d, 0x41, 0x52, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x51, 0x4c,
	0x5f, 0x43, 0x4f, 0x52, 0x45, 0x5f, 0x47, 0x52, 0x41, 0x4d, 0x4d, 0x41, 0x52, 0x10, 0x01, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x5f,
	0x47, 0x52, 0x41, 0x4d, 0x4d, 0x41, 0x52, 0x10, 0x02, 0x2a, 0x68, 0x0a, 0x1e, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x73, 0x69, 0x39, 0x32, 0x53, 0x71, 0x6c, 0x47,
	0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x14, 0x0a, 0x10, 0x41,
	0x4e, 0x53, 0x49, 0x39, 0x32, 0x5f, 0x45, 0x4e, 0x54, 0x52, 0x59, 0x5f, 0x53, 0x51, 0x4c, 0x10,
	0x00, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x4e, 0x53, 0x49, 0x39, 0x32, 0x5f, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x41, 0x4e, 0x53, 0x49, 0x39, 0x32, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x53, 0x51,
	0x4c, 0x10, 0x02, 0x2a, 0x6d, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x4f, 0x75, 0x74, 0x65, 0x72, 0x4a,
	0x6f, 0x69, 0x6e, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x51, 0x4c, 0x5f, 0x4a, 0x4f, 0x49, 0x4e, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x53,
	0x51, 0x4c, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x45, 0x52,
	0x5f, 0x4a, 0x4f, 0x49, 0x4e, 0x53, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x4f, 0x55, 0x54, 0x45, 0x52, 0x5f, 0x4a, 0x4f, 0x49, 0x4e, 0x53,
	0x10, 0x02, 0x2a, 0x51, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x51, 0x4c,
	0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x42, 0x59, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x4c, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x51, 0x4c, 0x5f, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x5f, 0x42, 0x59, 0x5f, 0x42, 0x45, 0x59, 0x4f, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x4c,
	0x45, 0x43, 0x54, 0x10, 0x01, 0x2a, 0x90, 0x01, 0x0a, 0x1a, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x45, 0x4c, 0x45, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52, 0x45,
	0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x53, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f,
	0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58,
	0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x01, 0x12, 0x28,
	0x0a, 0x24, 0x53, 0x51, 0x4c, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e,
	0x5f, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e,
	0x49, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x02, 0x2a, 0x56, 0x0a, 0x1e, 0x53, 0x71, 0x6c, 0x53,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x51,
	0x4c, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x5f, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x51, 0x4c, 0x5f, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x01,
	0x2a, 0x97, 0x01, 0x0a, 0x16, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x53, 0x75, 0x62, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x51, 0x4c, 0x5f, 0x53, 0x55, 0x42, 0x51, 0x55, 0x45, 0x52, 0x49, 0x45, 0x53, 0x5f, 0x49, 0x4e,
	0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x53, 0x10, 0x00, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x42, 0x51, 0x55, 0x45, 0x52, 0x49, 0x45, 0x53,
	0x5f, 0x49, 0x4e, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15,
	0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x42, 0x51, 0x55, 0x45, 0x52, 0x49, 0x45, 0x53, 0x5f, 0x49,
	0x4e, 0x5f, 0x49, 0x4e, 0x53, 0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x53,
	0x55, 0x42, 0x51, 0x55, 0x45, 0x52, 0x49, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x51, 0x55, 0x41,
	0x4e, 0x54, 0x49, 0x46, 0x49, 0x45, 0x44, 0x53, 0x10, 0x03, 0x2a, 0x36, 0x0a, 0x12, 0x53, 0x71,
	0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x51, 0x4c, 0x5f, 0x55, 0x4e, 0x49, 0x4f, 0x4e, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x51, 0x4c, 0x5f, 0x55, 0x4e, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x4c,
	0x10, 0x01, 0x2a, 0xc9, 0x01, 0x0a, 0x1c, 0x53, 0x71, 0x6c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x24, 0x0a,
	0x20, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x55, 0x4e, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x43, 0x4f, 0x4d, 0x4d,
	0x49, 0x54, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x50, 0x45, 0x41,
	0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c,
	0x53, 0x51, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x04, 0x2a, 0x89,
	0x01, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x53,
	0x51, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20,
	0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4d,
	0x41, 0x4e, 0x49, 0x50, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x02, 0x2a, 0xbc, 0x01, 0x0a, 0x19, 0x53,
	0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x53, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f,
	0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a,
	0x20, 0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26, 0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c,
	0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x52, 0x4f, 0x4c,
	0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x28, 0x0a, 0x24, 0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x52, 0x4f, 0x4c, 0x4c, 0x5f, 0x53, 0x45,
	0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x2a, 0xa2, 0x01, 0x0a, 0x20, 0x53, 0x71,
	0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x53, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x2a,
	0x0a, 0x26, 0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54,
	0x5f, 0x43, 0x4f, 0x4e, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x51,
	0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x43, 0x4f, 0x4e,
	0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e,
	0x4c, 0x59, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x53, 0x55,
	0x4c, 0x54, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e,
	0x43, 0x59, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x2a, 0x99,
	0x04, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e,
	0x56, 0x45, 0x52, 0x54, 0x5f, 0x42, 0x49, 0x47, 0x49, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x42, 0x49, 0x4e,
	0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e,
	0x56, 0x45, 0x52, 0x54, 0x5f, 0x42, 0x49, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x51,
	0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10, 0x03,
	0x12, 0x14, 0x0a, 0x10, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f,
	0x44, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f,
	0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x44, 0x45, 0x43, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x05, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x46,
	0x4c, 0x4f, 0x41, 0x54, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f,
	0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x07, 0x12,
	0x21, 0x0a, 0x1d, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x44, 0x41, 0x59, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x10, 0x08, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52,
	0x54, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x5f,
	0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x09, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x5f, 0x43,
	0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x56, 0x41, 0x52, 0x42, 0x49,
	0x4e, 0x41, 0x52, 0x59, 0x10, 0x0a, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f,
	0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41,
	0x52, 0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45,
	0x52, 0x54, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x0c, 0x12, 0x14, 0x0a, 0x10,
	0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x41, 0x4c,
	0x10, 0x0d, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52,
	0x54, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x49, 0x4e, 0x54, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10,
	0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x10, 0x0f, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52,
	0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x10, 0x12, 0x17, 0x0a,
	0x13, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x54, 0x49, 0x4e,
	0x59, 0x49, 0x4e, 0x54, 0x10, 0x11, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f,
	0x4e, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x56, 0x41, 0x52, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10,
	0x12, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x51, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54,
	0x5f, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41, 0x52, 0x10, 0x13, 0x2a, 0x8f, 0x04, 0x0a, 0x0c, 0x58,
	0x64, 0x62, 0x63, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x58,
	0x44, 0x42, 0x43, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x10,
	0x01, 0x12, 0x10, 0x0a, 0x0c, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49,
	0x43, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x44, 0x45, 0x43, 0x49,
	0x4d, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x58, 0x44, 0x42, 0x43, 0x5f,
	0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x49, 0x4e, 0x54, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x58, 0x44,
	0x42, 0x43, 0x5f, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x58, 0x44,
	0x42, 0x43, 0x5f, 0x52, 0x45, 0x41, 0x4c, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x58, 0x44, 0x42,
	0x43, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x11, 0x0a, 0x0d, 0x58, 0x44,
	0x42, 0x43, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x09, 0x12, 0x11, 0x0a,
	0x0d, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x10, 0x0a,
	0x12, 0x10, 0x0a, 0x0c, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41, 0x52,
	0x10, 0x0c, 0x12, 0x0d, 0x0a, 0x09, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x10,
	0x5b, 0x12, 0x0d, 0x0a, 0x09, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x5c,
	0x12, 0x12, 0x0a, 0x0e, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41,
	0x4d, 0x50, 0x10, 0x5d, 0x12, 0x1d, 0x0a, 0x10, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x4c, 0x4f, 0x4e,
	0x47, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41, 0x52, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x01, 0x12, 0x18, 0x0a, 0x0b, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x42, 0x49, 0x4e, 0x41,
	0x52, 0x59, 0x10, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x1b, 0x0a,
	0x0e, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x56, 0x41, 0x52, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10,
	0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x1f, 0x0a, 0x12, 0x58, 0x44,
	0x42, 0x43, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x56, 0x41, 0x52, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59,
	0x10, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x18, 0x0a, 0x0b, 0x58,
	0x44, 0x42, 0x43, 0x5f, 0x42, 0x49, 0x47, 0x49, 0x4e, 0x54, 0x10, 0xfb, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x19, 0x0a, 0x0c, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x54, 0x49,
	0x4e, 0x59, 0x49, 0x4e, 0x54, 0x10, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
	0x12, 0x15, 0x0a, 0x08, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x42, 0x49, 0x54, 0x10, 0xf9, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x17, 0x0a, 0x0a, 0x58, 0x44, 0x42, 0x43, 0x5f,
	0x57, 0x43, 0x48, 0x41, 0x52, 0x10, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,
	0x12, 0x1a, 0x0a, 0x0d, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x57, 0x56, 0x41, 0x52, 0x43, 0x48, 0x41,
	0x52, 0x10, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x2a, 0xa3, 0x08, 0x0a,
	0x13, 0x58, 0x64, 0x62, 0x63, 0x44, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x75, 0x62,
	0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x15,
	0x0a, 0x11, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x59,
	0x45, 0x41, 0x52, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55,
	0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43,
	0x4f, 0x44, 0x45, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x58,
	0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x58, 0x44, 0x42, 0x43, 0x5f,
	0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x03, 0x12, 0x23, 0x0a,
	0x1f, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5a, 0x4f, 0x4e, 0x45,
	0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f,
	0x44, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x04, 0x12, 0x28, 0x0a, 0x24, 0x58, 0x44, 0x42,
	0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54,
	0x41, 0x4d, 0x50, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5a, 0x4f, 0x4e,
	0x45, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43,
	0x4f, 0x44, 0x45, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13,
	0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x45, 0x43,
	0x4f, 0x4e, 0x44, 0x10, 0x06, 0x12, 0x1e, 0x0a, 0x1a, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55,
	0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x5f, 0x54, 0x4f, 0x5f, 0x4d, 0x4f,
	0x4e, 0x54, 0x48, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55,
	0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x41, 0x59, 0x5f, 0x54, 0x4f, 0x5f, 0x48, 0x4f, 0x55,
	0x52, 0x10, 0x08, 0x12, 0x1e, 0x0a, 0x1a, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43,
	0x4f, 0x44, 0x45, 0x5f, 0x44, 0x41, 0x59, 0x5f, 0x54, 0x4f, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54,
	0x45, 0x10, 0x09, 0x12, 0x1e, 0x0a, 0x1a, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43,
	0x4f, 0x44, 0x45, 0x5f, 0x44, 0x41, 0x59, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e,
	0x44, 0x10, 0x0a, 0x12, 0x1f, 0x0a, 0x1b, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43,
	0x4f, 0x44, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x5f, 0x54, 0x4f, 0x5f, 0x4d, 0x49, 0x4e, 0x55,
	0x54, 0x45, 0x10, 0x0b, 0x12, 0x1f, 0x0a, 0x1b, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x45, 0x43,
	0x4f, 0x4e, 0x44, 0x10, 0x0c, 0x12, 0x21, 0x0a, 0x1d, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55,
	0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x4f, 0x5f,
	0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x10, 0x0d, 0x12, 0x1e, 0x0a, 0x1a, 0x58, 0x44, 0x42, 0x43,
	0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41,
	0x4c, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x10, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x58, 0x44, 0x42, 0x43,
	0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41,
	0x4c, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x66, 0x12, 0x1d, 0x0a, 0x19, 0x58, 0x44, 0x42,
	0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56,
	0x41, 0x4c, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x67, 0x12, 0x1e, 0x0a, 0x1a, 0x58, 0x44, 0x42, 0x43,
	0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41,
	0x4c, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x68, 0x12, 0x20, 0x0a, 0x1c, 0x58, 0x44, 0x42, 0x43,
	0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41,
	0x4c, 0x5f, 0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x10, 0x69, 0x12, 0x20, 0x0a, 0x1c, 0x58, 0x44,
	0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x56, 0x41, 0x4c, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x10, 0x6a, 0x12, 0x27, 0x0a, 0x23,
	0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x5f, 0x54, 0x4f, 0x5f, 0x4d, 0x4f,
	0x4e, 0x54, 0x48, 0x10, 0x6b, 0x12, 0x25, 0x0a, 0x21, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55,
	0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x44,
	0x41, 0x59, 0x5f, 0x54, 0x4f, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x6c, 0x12, 0x27, 0x0a, 0x23,
	0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x44, 0x41, 0x59, 0x5f, 0x54, 0x4f, 0x5f, 0x4d, 0x49, 0x4e,
	0x55, 0x54, 0x45, 0x10, 0x6d, 0x12, 0x27, 0x0a, 0x23, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55,
	0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x44,
	0x41, 0x59, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x10, 0x6e, 0x12, 0x28,
	0x0a, 0x24, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x5f, 0x54, 0x4f, 0x5f,
	0x4d, 0x49, 0x4e, 0x55, 0x54, 0x45, 0x10, 0x6f, 0x12, 0x28, 0x0a, 0x24, 0x58, 0x44, 0x42, 0x43,
	0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41,
	0x4c, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44,
	0x10, 0x70, 0x12, 0x2a, 0x0a, 0x26, 0x58, 0x44, 0x42, 0x43, 0x5f, 0x53, 0x55, 0x42, 0x43, 0x4f,
	0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x4d, 0x49, 0x4e, 0x55,
	0x54, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x10, 0x71, 0x1a, 0x02,
	0x10, 0x01, 0x2a, 0x57, 0x0a, 0x08, 0x4e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x18,
	0x0a, 0x14, 0x4e, 0x55, 0x4c, 0x4c, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x4f,
	0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x53, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x55, 0x4c, 0x4c,
	0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x55, 0x4c, 0x4c, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x2a, 0x61, 0x0a, 0x0a, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x41,
	0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41,
	0x52, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x41,
	0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x03, 0x2a, 0x5c,
	0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x41, 0x53, 0x43, 0x41, 0x44, 0x45, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x45, 0x54, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x4e, 0x4f, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x53,
	0x45, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x04, 0x3a, 0x44, 0x0a, 0x0c,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x12, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xe8, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x42, 0x56, 0x0a, 0x20, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x69, 0x6d, 0x70, 0x6c, 0x5a, 0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2f, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2f,
	0x67, 0x65, 0x6e, 0x2f, 0x66, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_FlightSql_proto_rawDescOnce sync.Once
	file_FlightSql_proto_rawDescData = file_FlightSql_proto_rawDesc
)

func file_FlightSql_proto_rawDescGZIP() []byte {
	file_FlightSql_proto_rawDescOnce.Do(func() {
		file_FlightSql_proto_rawDescData = protoimpl.X.CompressGZIP(file_FlightSql_proto_rawDescData)
	})
	return file_FlightSql_proto_rawDescData
}

var file_FlightSql_proto_enumTypes = make([]protoimpl.EnumInfo, 25)
var file_FlightSql_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_FlightSql_proto_goTypes = []interface{}{
	(SqlInfo)(0),                                     // 0: arrow.flight.protocol.sql.SqlInfo
	(SqlSupportedTransaction)(0),                     // 1: arrow.flight.protocol.sql.SqlSupportedTransaction
	(SqlSupportedCaseSensitivity)(0),                 // 2: arrow.flight.protocol.sql.SqlSupportedCaseSensitivity
	(SqlNullOrdering)(0),                             // 3: arrow.flight.protocol.sql.SqlNullOrdering
	(SupportedSqlGrammar)(0),                         // 4: arrow.flight.protocol.sql.SupportedSqlGrammar
	(SupportedAnsi92SqlGrammarLevel)(0),              // 5: arrow.flight.protocol.sql.SupportedAnsi92SqlGrammarLevel
	(SqlOuterJoinsSupportLevel)(0),                   // 6: arrow.flight.protocol.sql.SqlOuterJoinsSupportLevel
	(SqlSupportedGroupBy)(0),                         // 7: arrow.flight.protocol.sql.SqlSupportedGroupBy
	(SqlSupportedElementActions)(0),                  // 8: arrow.flight.protocol.sql.SqlSupportedElementActions
	(SqlSupportedPositionedCommands)(0),              // 9: arrow.flight.protocol.sql.SqlSupportedPositionedCommands
	(SqlSupportedSubqueries)(0),                      // 10: arrow.flight.protocol.sql.SqlSupportedSubqueries
	(SqlSupportedUnions)(0),                          // 11: arrow.flight.protocol.sql.SqlSupportedUnions
	(SqlTransactionIsolationLevel)(0),                // 12: arrow.flight.protocol.sql.SqlTransactionIsolationLevel
	(SqlSupportedTransactions)(0),                    // 13: arrow.flight.protocol.sql.SqlSupportedTransactions
	(SqlSupportedResultSetType)(0),                   // 14: arrow.flight.protocol.sql.SqlSupportedResultSetType
	(SqlSupportedResultSetConcurrency)(0),            // 15: arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency
	(SqlSupportsConvert)(0),                          // 16: arrow.flight.protocol.sql.SqlSupportsConvert
	(XdbcDataType)(0),                                // 17: arrow.flight.protocol.sql.XdbcDataType
	(XdbcDatetimeSubcode)(0),                         // 18: arrow.flight.protocol.sql.XdbcDatetimeSubcode
	(Nullable)(0),                                    // 19: arrow.flight.protocol.sql.Nullable
	(Searchable)(0),                                  // 20: arrow.flight.protocol.sql.Searchable
	(UpdateDeleteRules)(0),                           // 21: arrow.flight.protocol.sql.UpdateDeleteRules
	(ActionEndTransactionRequest_EndTransaction)(0),  // 22: arrow.flight.protocol.sql.ActionEndTransactionRequest.EndTransaction
	(ActionEndSavepointRequest_EndSavepoint)(0),      // 23: arrow.flight.protocol.sql.ActionEndSavepointRequest.EndSavepoint
	(ActionCancelQueryResult_CancelResult)(0),        // 24: arrow.flight.protocol.sql.ActionCancelQueryResult.CancelResult
	(*CommandGetSqlInfo)(nil),                        // 25: arrow.flight.protocol.sql.CommandGetSqlInfo
	(*CommandGetXdbcTypeInfo)(nil),                   // 26: arrow.flight.protocol.sql.CommandGetXdbcTypeInfo
	(*CommandGetCatalogs)(nil),                       // 27: arrow.flight.protocol.sql.CommandGetCatalogs
	(*CommandGetDbSchemas)(nil),                      // 28: arrow.flight.protocol.sql.CommandGetDbSchemas
	(*CommandGetTables)(nil),                         // 29: arrow.flight.protocol.sql.CommandGetTables
	(*CommandGetTableTypes)(nil),                     // 30: arrow.flight.protocol.sql.CommandGetTableTypes
	(*CommandGetPrimaryKeys)(nil),                    // 31: arrow.flight.protocol.sql.CommandGetPrimaryKeys
	(*CommandGetExportedKeys)(nil),                   // 32: arrow.flight.protocol.sql.CommandGetExportedKeys
	(*CommandGetImportedKeys)(nil),                   // 33: arrow.flight.protocol.sql.CommandGetImportedKeys
	(*CommandGetCrossReference)(nil),                 // 34: arrow.flight.protocol.sql.CommandGetCrossReference
	(*ActionCreatePreparedStatementRequest)(nil),     // 35: arrow.flight.protocol.sql.ActionCreatePreparedStatementRequest
	(*SubstraitPlan)(nil),                            // 36: arrow.flight.protocol.sql.SubstraitPlan
	(*ActionCreatePreparedSubstraitPlanRequest)(nil), // 37: arrow.flight.protocol.sql.ActionCreatePreparedSubstraitPlanRequest
	(*ActionCreatePreparedStatementResult)(nil),      // 38: arrow.flight.protocol.sql.ActionCreatePreparedStatementResult
	(*ActionClosePreparedStatementRequest)(nil),      // 39: arrow.flight.protocol.sql.ActionClosePreparedStatementRequest
	(*ActionBeginTransactionRequest)(nil),            // 40: arrow.flight.protocol.sql.ActionBeginTransactionRequest
	(*ActionBeginSavepointRequest)(nil),              // 41: arrow.flight.protocol.sql.ActionBeginSavepointRequest
	(*ActionBeginTransactionResult)(nil),             // 42: arrow.flight.protocol.sql.ActionBeginTransactionResult
	(*ActionBeginSavepointResult)(nil),               // 43: arrow.flight.protocol.sql.ActionBeginSavepointResult
	(*ActionEndTransactionRequest)(nil),              // 44: arrow.flight.protocol.sql.ActionEndTransactionRequest
	(*ActionEndSavepointRequest)(nil),                // 45: arrow.flight.protocol.sql.ActionEndSavepointRequest
	(*CommandStatementQuery)(nil),                    // 46: arrow.flight.protocol.sql.CommandStatementQuery
	(*CommandStatementSubstraitPlan)(nil),            // 47: arrow.flight.protocol.sql.CommandStatementSubstraitPlan
	(*TicketStatementQuery)(nil),                     // 48: arrow.flight.protocol.sql.TicketStatementQuery
	(*CommandPreparedStatementQuery)(nil),            // 49: arrow.flight.protocol.sql.CommandPreparedStatementQuery
	(*CommandStatementUpdate)(nil),                   // 50: arrow.flight.protocol.sql.CommandStatementUpdate
	(*CommandPreparedStatementUpdate)(nil),           // 51: arrow.flight.protocol.sql.CommandPreparedStatementUpdate
	(*DoPutUpdateResult)(nil),                        // 52: arrow.flight.protocol.sql.DoPutUpdateResult
	(*ActionCancelQueryRequest)(nil),                 // 53: arrow.flight.protocol.sql.ActionCancelQueryRequest
	(*ActionCancelQueryResult)(nil),                  // 54: arrow.flight.protocol.sql.ActionCancelQueryResult
	(*descriptorpb.MessageOptions)(nil),              // 55: google.protobuf.MessageOptions
}
var file_FlightSql_proto_depIdxs = []int32{
	36, // 0: arrow.flight.protocol.sql.ActionCreatePreparedSubstraitPlanRequest.plan:type_name -> arrow.flight.protocol.sql.SubstraitPlan
	22, // 1: arrow.flight.protocol.sql.ActionEndTransactionRequest.action:type_name -> arrow.flight.protocol.sql.ActionEndTransactionRequest.EndTransaction
	23, // 2: arrow.flight.protocol.sql.ActionEndSavepointRequest.action:type_name -> arrow.flight.protocol.sql.ActionEndSavepointRequest.EndSavepoint
	36, // 3: arrow.flight.protocol.sql.CommandStatementSubstraitPlan.plan:type_name -> arrow.flight.protocol.sql.SubstraitPlan
	24, // 4: arrow.flight.protocol.sql.ActionCancelQueryResult.result:type_name -> arrow.flight.protocol.sql.ActionCancelQueryResult.CancelResult
	55, // 5: arrow.flight.protocol.sql.experimental:extendee -> google.protobuf.MessageOptions
	6,  // [6:6] is the sub-list for method output_type
	6,  // [6:6] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	5,  // [5:6] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_FlightSql_proto_init() }
func file_FlightSql_proto_init() {
	if File_FlightSql_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_FlightSql_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetSqlInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetXdbcTypeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetCatalogs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetDbSchemas); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetTables); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetTableTypes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetPrimaryKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetExportedKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetImportedKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandGetCrossReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionCreatePreparedStatementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubstraitPlan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionCreatePreparedSubstraitPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionCreatePreparedStatementResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionClosePreparedStatementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionBeginTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionBeginSavepointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionBeginTransactionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionBeginSavepointResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionEndTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionEndSavepointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandStatementQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandStatementSubstraitPlan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TicketStatementQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandPreparedStatementQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandStatementUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandPreparedStatementUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoPutUpdateResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionCancelQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_FlightSql_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionCancelQueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_FlightSql_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[21].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[22].OneofWrappers = []interface{}{}
	file_FlightSql_proto_msgTypes[25].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_FlightSql_proto_rawDesc,
			NumEnums:      25,
			NumMessages:   30,
			NumExtensions: 1,
			NumServices:   0,
		},
		GoTypes:           file_FlightSql_proto_goTypes,
		DependencyIndexes: file_FlightSql_proto_depIdxs,
		EnumInfos:         file_FlightSql_proto_enumTypes,
		MessageInfos:      file_FlightSql_proto_msgTypes,
		ExtensionInfos:    file_FlightSql_proto_extTypes,
	}.Build()
	File_FlightSql_proto = out.File
	file_FlightSql_proto_rawDesc = nil
	file_FlightSql_proto_goTypes = nil
	file_FlightSql_proto_depIdxs = nil
}
